library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity SyncReset is

port( 
	IRST: in std_logic ;
	CLK: in std_logic ;
	ORST: out std_logic  );

end;

architecture Behavioral of SyncReset is

  signal sync_latch : std_logic;

begin

  process(CLK, IRST)
  begin
    if IRST'event and IRST='1' then
      sync_latch <= IRST;
    end if;

    if CLK'event and CLK='1' then
      if sync_latch = '1' then
        sync_latch <= '0';
        ORST <= '1';
      else
        ORST <= '0';
      end if;
    end if;
  end process;

end Behavioral;

