----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    20:26:55 09/17/2006 
-- Design Name: 
-- Module Name:    ramen_timer - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity ramen_timer is
  Port ( CLK : in  STD_LOGIC;
         RESET : in STD_LOGIC;
         SW1 : in  STD_LOGIC;
         SW2 : in  STD_LOGIC;
         SW3 : in  STD_LOGIC;
         SW4 : in  STD_LOGIC;
         SEG7_1 : out  STD_LOGIC_VECTOR (7 downto 0);
         SEG7_2 : out  STD_LOGIC_VECTOR (7 downto 0);
         SEG7_3 : out  STD_LOGIC_VECTOR (7 downto 0);
         SEG7_4 : out  STD_LOGIC_VECTOR (7 downto 0);
         BEEP : out  STD_LOGIC);
end ramen_timer;


-- impriment
architecture Behavioral of ramen_timer is

  component counter10
    Port ( CLK : in STD_LOGIC;
           INCDEC : in  STD_LOGIC;
           RESET : in  STD_LOGIC;
           DAT : in  STD_LOGIC_VECTOR (3 downto 0);
           Q : out  STD_LOGIC_VECTOR (3 downto 0);
           WE : in  STD_LOGIC;
           CARRY : out  STD_LOGIC);
  end component;

  component Bin2Seg
    Port( DATA: in std_logic_vector ( 3 downto 0 );
          SEG: out std_logic_vector ( 7 downto 0 ) );
  end component;

  component SyncReset
    Port( IRST : in STD_LOGIC;
          CLK : in STD_LOGIC;
          ORST : out STD_LOGIC );
  end component;

  component Alerm
    Port( CLK: in std_logic ;
	RESET: in std_logic ;
	TRG: in std_logic ;
	BEEPOUT: out std_logic );
  end component;

  signal  keyreset : STD_LOGIC;
  signal  sysreset : STD_LOGIC;

  signal  timer : STD_LOGIC_VECTOR(19 downto 0);
  signal  count_signal : STD_LOGIC;

  signal  display1 : STD_LOGIC_VECTOR(3 downto 0);
  signal  display2 : STD_LOGIC_VECTOR(3 downto 0);
  signal  display3 : STD_LOGIC_VECTOR(3 downto 0);
  signal  display4 : STD_LOGIC_VECTOR(3 downto 0);
  signal  setnum1 : STD_LOGIC_VECTOR(3 downto 0);
  signal  setnum2 : STD_LOGIC_VECTOR(3 downto 0);
  signal  setnum3 : STD_LOGIC_VECTOR(3 downto 0);
  signal  setnum4 : STD_LOGIC_VECTOR(3 downto 0);
  signal  seg3_latch : STD_LOGIC_VECTOR(7 downto 0);
  signal  carry1 : STD_LOGIC;
  signal  carry2 : STD_LOGIC;
  signal  carry3 : STD_LOGIC;
  signal  carry4 : STD_LOGIC;
  signal  swrite : STD_LOGIC;
  signal  nop : STD_LOGIC;
  signal  direction : STD_LOGIC;
  signal  beep_trg : STD_LOGIC;

begin

  KETA1 : counter10 port map(count_signal,
                             direction,
                             nop,
                             setnum4,
                             display4,
                             swrite,
                             carry1);
  KETA2 : counter10 port map(carry1,
                             direction,
                             nop,
                             setnum3,
                             display3,
                             swrite,
                             carry2);
  KETA3 : counter10 port map(carry2,
                             direction,
                             nop,
                             setnum2,
                             display2,
                             swrite,
                             carry3);
  KETA4 : counter10 port map(carry3,
                             direction,
                             nop,
                             setnum1,
                             display1,
                             swrite,
                             carry4);

  -- display 7segment LED
  DISP1 : Bin2Seg port map( display1, SEG7_1 );
  DISP2 : Bin2Seg port map( display2, SEG7_2 );
  DISP3 : Bin2Seg port map( display3, seg3_latch );
  DISP4 : Bin2Seg port map( display4, SEG7_4 );

  -- easy sync reset
  SRST : SyncReset port map(keyreset, CLK, sysreset );

  -- beep
  SOUND : Alerm port map ( CLK, sysreset, beep_trg, BEEP );

  
  process(CLK, RESET, SW1, SW2, SW3, SW4)
  begin
    nop <= '0';
    direction <= '0';
    keyreset <= not RESET;

    SEG7_3(0) <= seg3_latch(0);
    SEG7_3(1) <= seg3_latch(1);
    SEG7_3(2) <= seg3_latch(2);
    SEG7_3(3) <= seg3_latch(3);
    SEG7_3(4) <= seg3_latch(4);
    SEG7_3(5) <= seg3_latch(5);
    SEG7_3(6) <= seg3_latch(6);
    
    if CLK'event and CLK='1' then
      -- wait loop
      timer <= timer + '1';
      if timer = "11110100001001000000" then
        timer <= "00000000000000000000";
        if (display1 or display2 or display3 or display4) = "0000" then
          count_signal <= '0';
        else
          count_signal <= '1';
        end if;
      else
        count_signal <= '0';
      end if;

      -- start key
      if SW1 = '1' then
        setnum1 <= "0000";
        setnum2 <= "0110";
        setnum3 <= "0000";
        setnum4 <= "0000";
        swrite <= '1';
      elsif SW2 = '1' then
        setnum1 <= "0001";
        setnum2 <= "1000";
        setnum3 <= "0000";
        setnum4 <= "0000";
        swrite <= '1';
      elsif SW3 = '1' then
        setnum1 <= "0010";
        setnum2 <= "0100";
        setnum3 <= "0000";
        setnum4 <= "0000";
        swrite <= '1';
      elsif SW4 = '0' then
        setnum1 <= "0011";
        setnum2 <= "0000";
        setnum3 <= "0000";
        setnum4 <= "0000";
        swrite <= '1';
      elsif sysreset = '1' then
        setnum1 <= "0000";
        setnum2 <= "0000";
        setnum3 <= "0000";
        setnum4 <= "0000";
        swrite <= '1';
      else
        swrite <= '0';
      end if;
      
      -- second period
      if display4 = "0000" then
        SEG7_3(7) <= '1';
      elsif display4 = "0001" then
        SEG7_3(7) <= '1';
      elsif display4 = "0010" then
        SEG7_3(7) <= '1';
      elsif display4 = "0011" then
        SEG7_3(7) <= '1';
      elsif display4 = "0100" then
        SEG7_3(7) <= '1';
      elsif display4 = "0101" then
        SEG7_3(7) <= '0';
      elsif display4 = "0110" then
        SEG7_3(7) <= '0';
      elsif display4 = "0111" then
      	SEG7_3(7) <= '0';
      elsif display4 = "1000" then
        SEG7_3(7) <= '0';
      elsif display4 = "1001" then
        SEG7_3(7) <= '0';
      end if;

      -- done alerm
      if (display1 = "0000") and (display2 = "0000") and (display3 = "0000") and (display4 = "0001")then
        beep_trg <= '1';
      else
        beep_trg <= '0';
      end if;
    end if;  -- from CLK
  end process;

end Behavioral;

