----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    21:00:37 09/17/2006 
-- Design Name: 
-- Module Name:    counter10 - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity counter10 is
  Port ( CLK : in STD_LOGIC;
         INCDEC : in  STD_LOGIC;
         RESET : in  STD_LOGIC;
         DAT : in  STD_LOGIC_VECTOR (3 downto 0);
         Q : out  STD_LOGIC_VECTOR (3 downto 0);
         WE : in  STD_LOGIC;
         CARRY : out  STD_LOGIC);
end counter10;


architecture Behavioral of counter10 is

  signal  count : STD_LOGIC_VECTOR(3 downto 0) := "0000";

begin

  process(CLK, RESET, INCDEC, WE)
  begin
    if CLK'event and CLK='1' then
      --- counter inclement
      if INCDEC = '1' then
        if count = "1001" then
          count <= "0000";
          CARRY <= '1';
        else
          count <= count + '1';
          CARRY <= '0';
        end if;
        --- counter decriment
      else
        if count = "0000" then
          count <= "1001";
          CARRY <= '1';
        else
          count <= count - '1';
          CARRY <= '0';
        end if;
      end if;
    end if;

    --- reset clear
    if RESET='1' then
      count <= "0000";
      CARRY <= '0';
    end if;
    
    --- counter set
    if WE='1' then
      count <= DAT;
      CARRY <= '0';
    end if;

  end process;

  Q <= count;

end Behavioral;

