library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity Alerm is

port( 
	CLK: in std_logic ;
	RESET: in std_logic ;
	TRG: in std_logic ;
	BEEPOUT: out std_logic  );

end;

architecture Behavioral of Alerm is

  signal wave_counter : std_logic_vector ( 12 downto 0 );
  signal timing_counter : std_logic_vector ( 19 downto 0 );
  signal pattern_counter : std_logic_vector ( 4 downto 0 );
  signal loop_counter : std_logic_vector ( 2 downto 0 );
  signal osc : std_logic;
  signal beep : std_logic;

begin

  process(CLK, RESET, TRG)
  begin
    if CLK'event and CLK='1' then

      -- reset
      if RESET = '1' then
        loop_counter <= "000";
      end if;

      -- start
      if TRG = '1' then
        loop_counter <= "100";
      end if;

      -- osc
      wave_counter <= wave_counter + '1';
      if wave_counter = "1011000110010" then
        wave_counter <= "0000000000000";
        if osc = '0' then
          osc <= '1';
        else
          osc <= '0';
        end if;
      end if;

      -- timing
      timing_counter <= timing_counter + '1';
      if timing_counter = "11110100001001000000" then
        timing_counter <= "00000000000000000000";
        pattern_counter <= pattern_counter + '1';
        if (pattern_counter(0) = '1') and (pattern_counter(3) = '1')  then
          beep <= '1';
        else
          beep <= '0';
        end if;
        if (pattern_counter = "00000") and (loop_counter /= "000") then
          loop_counter <= loop_counter - '1';
        end if;
      end if;

      -- beep out
      if (beep = '1') and (loop_counter /= "000") then
        BEEPOUT <= osc;
      else
        BEEPOUT <= '0';
      end if;
    end if;

  end process;

end Behavioral;

