library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity Bin2Seg is

  port( 
    DATA: in std_logic_vector ( 3 downto 0 );
    SEG: out std_logic_vector ( 7 downto 0 ) );

end;

architecture Behavioral of Bin2Seg is
begin

  process(DATA)
  begin
    case DATA is
      when "0000" => SEG <= "11000000";
      when "0001" => SEG <= "11111001";
      when "0010" => SEG <= "10100100";
      when "0011" => SEG <= "10110000";
      when "0100" => SEG <= "10011001";
      when "0101" => SEG <= "10010010";
      when "0110" => SEG <= "10000010";
      when "0111" => SEG <= "11011000";
      when "1000" => SEG <= "10000000";
      when "1001" => SEG <= "10010000";
      when "1010" => SEG <= "10001000";
      when "1011" => SEG <= "10000011";
      when "1100" => SEG <= "11000110";
      when "1101" => SEG <= "10100001";
      when "1110" => SEG <= "10000110";
      when "1111" => SEG <= "10001110";
      when others => SEG <= "XXXXXXXX";
    end case;
  end process;

end Behavioral;

