#include <m8c.h>        // part specific constants and macros
#include "main.h"


/* ------------------- */
/* --- Parameter       */
/* ------------------- */

//! my midi channel
BYTE  bMyMidiChannel;

//! output 8polyphony
BYTE  bMidiOutPoly;

//! output 8polyphony / 16poly mode
BYTE  bMidiOutPoly2;

//! output monophony tone
BYTE  bMidiMonoTone;

//! output monophony torigger
BYTE  bMidiMonoTrigger;

//! output velocity
BYTE  bMidiVelocity[8];

//! controller option
BYTE  bMidiOption;


/* ------------------- */
/* --- local           */
/* ------------------- */

//! receive command
BYTE  bMidiCommand;

//! receive data count
BYTE  bMidiDataLength;
BYTE  bMidiDataLengthCounter;

//! drop data count
BYTE  bMidiSkipLength;

//! receive data
BYTE  bMidiReceivePointer;
BYTE  bMidiReceive[128+3];



/* ---------------------------------------- */
/* --- MIDI processing                      */
/* ---------------------------------------- */


/* --------------------------- */
/* --- reset status */
void SetMidiChannel(BYTE  bCh)
{
	bMyMidiChannel = bCh;
}


/* --------------------------- */
/* --- reset status */
void MidiReset(void)
{
	bMidiCommand = 0;
	bMidiDataLength = 0;
	bMidiDataLengthCounter = 0;
	bMidiSkipLength = 0;
	bMidiReceivePointer = 0;
	bMidiOutPoly = 0;
	bMidiMonoTone = 0;
	bMidiMonoTrigger = 0;
	bMidiOption = 0;
}


/* --------------------------- */
/* --- proceccing */
void MidiProcess(void)
{
	/* --- receipt my ch. data */
	if ((bMidiReceive[0] & 0x0f) != bMyMidiChannel) {
		return;
	}
	
	/* --- process note command */
	switch(bMidiReceive[0] & 0xf0) {
			/* - note off */
		case 0x80:
			if (bMidiReceive[1] == bMidiMonoTone) {
				bMidiMonoTrigger = 0;
			}
			if (bMidiReceive[1] == 48) bMidiOutPoly &= 0b11111110;
			if (bMidiReceive[1] == 49) bMidiOutPoly &= 0b11111101;
			if (bMidiReceive[1] == 50) bMidiOutPoly &= 0b11111011;
			if (bMidiReceive[1] == 51) bMidiOutPoly &= 0b11110111;
			if (bMidiReceive[1] == 52) bMidiOutPoly &= 0b11101111;
			if (bMidiReceive[1] == 53) bMidiOutPoly &= 0b11011111;
			if (bMidiReceive[1] == 54) bMidiOutPoly &= 0b10111111;
			if (bMidiReceive[1] == 55) bMidiOutPoly &= 0b01111111;
			if (bMidiReceive[1] == 56) bMidiOutPoly2 &= 0b11111110;
			if (bMidiReceive[1] == 57) bMidiOutPoly2 &= 0b11111101;
			if (bMidiReceive[1] == 58) bMidiOutPoly2 &= 0b11111011;
			if (bMidiReceive[1] == 59) bMidiOutPoly2 &= 0b11110111;
			if (bMidiReceive[1] == 60) bMidiOutPoly2 &= 0b11101111;
			if (bMidiReceive[1] == 61) bMidiOutPoly2 &= 0b11011111;
			if (bMidiReceive[1] == 62) bMidiOutPoly2 &= 0b10111111;
			if (bMidiReceive[1] == 63) bMidiOutPoly2 &= 0b01111111;
			break;

			/* - note on */
		case 0x90:
			bMidiMonoTone = bMidiReceive[1];
			if (bMidiReceive[2] != 0) {
				bMidiMonoTrigger = 1;
				if (bMidiReceive[1] == 48) bMidiOutPoly |= 0b00000001;
				if (bMidiReceive[1] == 49) bMidiOutPoly |= 0b00000010;
				if (bMidiReceive[1] == 50) bMidiOutPoly |= 0b00000100;
				if (bMidiReceive[1] == 51) bMidiOutPoly |= 0b00001000;
				if (bMidiReceive[1] == 52) bMidiOutPoly |= 0b00010000;
				if (bMidiReceive[1] == 53) bMidiOutPoly |= 0b00100000;
				if (bMidiReceive[1] == 54) bMidiOutPoly |= 0b01000000;
				if (bMidiReceive[1] == 55) bMidiOutPoly |= 0b10000000;
				if (bMidiReceive[1] == 56) {
					bMidiOutPoly2 |= 0b00000001;
					bMidiVelocity[0] = bMidiReceive[2];
				}
				if (bMidiReceive[1] == 57) {
					bMidiOutPoly2 |= 0b00000010;
					bMidiVelocity[1] = bMidiReceive[2];
				}
				if (bMidiReceive[1] == 58) {
					bMidiOutPoly2 |= 0b00000100;
					bMidiVelocity[2] = bMidiReceive[2];
				}
				if (bMidiReceive[1] == 59) {
					bMidiOutPoly2 |= 0b00001000;
					bMidiVelocity[3] = bMidiReceive[2];
				}
				if (bMidiReceive[1] == 60) {
					bMidiOutPoly2 |= 0b00010000;
					bMidiVelocity[4] = bMidiReceive[2];
				}
				if (bMidiReceive[1] == 61) {
					bMidiOutPoly2 |= 0b00100000;
					bMidiVelocity[5] = bMidiReceive[2];
				}
				if (bMidiReceive[1] == 62) {
					bMidiOutPoly2 |= 0b01000000;
					bMidiVelocity[6] = bMidiReceive[2];
				}
				if (bMidiReceive[1] == 63) {
					bMidiOutPoly2 |= 0b10000000;
					bMidiVelocity[7] = bMidiReceive[2];
				}
			}
			else {
				/* off */
				bMidiMonoTrigger = 0;
				if (bMidiReceive[1] == 48) bMidiOutPoly &= 0b11111110;
				if (bMidiReceive[1] == 49) bMidiOutPoly &= 0b11111101;
				if (bMidiReceive[1] == 50) bMidiOutPoly &= 0b11111011;
				if (bMidiReceive[1] == 51) bMidiOutPoly &= 0b11110111;
				if (bMidiReceive[1] == 52) bMidiOutPoly &= 0b11101111;
				if (bMidiReceive[1] == 53) bMidiOutPoly &= 0b11011111;
				if (bMidiReceive[1] == 54) bMidiOutPoly &= 0b10111111;
				if (bMidiReceive[1] == 55) bMidiOutPoly &= 0b01111111;
				if (bMidiReceive[1] == 56) {
					bMidiOutPoly2 &= 0b11111110;
					bMidiVelocity[0] = 0;
				}
				if (bMidiReceive[1] == 57) {
					bMidiOutPoly2 &= 0b11111101;
					bMidiVelocity[1] = 0;
				}
				if (bMidiReceive[1] == 58) {
					bMidiOutPoly2 &= 0b11111011;
					bMidiVelocity[2] = 0;
				}
				if (bMidiReceive[1] == 59) {
					bMidiOutPoly2 &= 0b11110111;
					bMidiVelocity[3] = 0;
				}
				if (bMidiReceive[1] == 60) {
					bMidiOutPoly2 &= 0b11101111;
					bMidiVelocity[4] = 0;
				}
				if (bMidiReceive[1] == 61) {
					bMidiOutPoly2 &= 0b11011111;
					bMidiVelocity[5] = 0;
				}
				if (bMidiReceive[1] == 62) {
					bMidiOutPoly2 &= 0b10111111;
					bMidiVelocity[6] = 0;
				}
				if (bMidiReceive[1] == 63) {
					bMidiOutPoly2 &= 0b01111111;
					bMidiVelocity[7] = 0;
				}
			}
			break;

			/* - mode */
		case 0xb0:
			/* all off */
			if (0x78 == bMidiReceive[1]) {
				bMidiOutPoly = 0;
				bMidiMonoTone = 0;
				bMidiMonoTrigger = 0;
			}
			/* local option */
			if (0x7a == bMidiReceive[1]) {
				bMidiOption = bMidiReceive[2];
			}
			break;

		default:
			break;		
	}
	
	/* --- execute */
	KanadeOutput();
}


/* --------------------------- */
/* --- byte receive */
void MidiReceive(BYTE bData)
{
	/* activesense or timingclock */
	if ((0xfe == bData) || (0xf8 == bData)) {
		/* no work */
		return;
	}

	/* --- receive command */
	if ((bData & 0b10000000) != 0) {
		switch(bData&0xf0) {
			/* note off */
			case 0x80:
				bMidiDataLength = 2;
				break;

			/* note on */
			case 0x90:
				bMidiDataLength = 2;
				break;

			/* after touch poly */
			case 0xa0:
				bMidiDataLength = 2;
				break;

			/* after touch */
			case 0xd0:
				bMidiDataLength = 1;
				break;

			/* pitchbend */
			case 0xe0:
				bMidiDataLength = 2;
				break;

			/* control change, mode message */
			case 0xb0:
				bMidiDataLength = 2;
				break;

			/* program change */
			case 0xc0:
				bMidiDataLength = 1;
				break;

			/* exclusive message, etc. */
			case 0xf0:
				bMidiDataLength = 127;
				if (0xf7 == bData) bData=0xf0;
				break;

		}
		bMidiDataLengthCounter = bMidiDataLength;
		bMidiCommand = bData;
		bMidiReceive[0] = bData;
		bMidiReceivePointer = 1;
	}

	/* --- receive data */
	else if (bMidiDataLengthCounter > 0) {
		bMidiReceive[bMidiReceivePointer] = bData;
		bMidiReceivePointer++;
		bMidiDataLengthCounter--;
		if (0 == bMidiDataLengthCounter) {
			MidiProcess();
			/* running status */
			bMidiReceivePointer = 1;
			bMidiDataLengthCounter = bMidiDataLength;
		}
		return;
	}
}
