//----------------------------------------------------------------------------
// C main line
//----------------------------------------------------------------------------

#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules

#include "midi_receive.h"
#include "tonetable.h"


#define  BUFFERSIZE  64

/* ------------------ */
/* - global value     */
/* ------------------ */

// receive data from MIDI in
BYTE  g_bRxReceive;

// receive ring buffer
BYTE  bRxBuffer[BUFFERSIZE];
// ring buffer pointer
BYTE  bReceivePointer, bProcessPointer;

// output trigger
BYTE  bOutputFlag;
BYTE  bOutputTone;

// previous Option Mode
BYTE  bPrevOption;

// PWM duty
BYTE  bOutDuty[8];

/* ------------------ */
/* - int handler      */
/* ------------------ */

/* --- RX8 receive intrrupt */
#pragma interrupt_handler ReceiveRx8
void ReceiveRx8(void)
{
	bRxBuffer[bReceivePointer] = g_bRxReceive;
	bReceivePointer++;
	bReceivePointer &= (BUFFERSIZE-1);
}


/* ------------------ */
/* - Kanade work     */
/* ------------------ */

/* --- PWM control */
void KanadePWM(void)
{
	WORD  length;

	if ((bMidiOption & 0b00100000) != 0) {
		/* - SERVO control PWM */
		PWM16_1_WritePeriod(30052);
		length = 18 * bMidiMonoTone;
		length += 1500;
		PWM16_1_WritePulseWidth(length);
	}
	else {
		/* - tone start */
		if ((0 == bOutputFlag) && (1 == bMidiMonoTrigger)) {
			PWM16_1_Stop();
			PWM16_1_WritePeriod(ToneTable[bMidiMonoTone]);
			PWM16_1_WritePulseWidth(ToneTable[bMidiMonoTone]>>1);
			PWM16_1_Start();
			bOutputTone = bMidiMonoTone;
		}
		else if ((1 == bOutputFlag) && (bMidiMonoTone != bOutputTone)) {
			PWM16_1_Stop();
			PWM16_1_WritePeriod(ToneTable[bMidiMonoTone]);
			PWM16_1_WritePulseWidth(ToneTable[bMidiMonoTone]>>1);
			PWM16_1_Start();
			bOutputTone = bMidiMonoTone;
		}
		/* - tone stop */
		if ((bMidiOption & 0b00010000) == 0) {
			if ((1 == bOutputFlag) && (0 == bMidiMonoTrigger)) {
				PWM16_1_Stop();
				PWM16_1_WritePeriod(2);
				PWM16_1_WritePulseWidth(2);
				PWM16_1_Start();
			}
		}
	}
	bOutputFlag = bMidiMonoTrigger;
}


/* --- PWM control 8ch mode (option) */
void KanadePWM2(void)
{
	BYTE  i, countbit, setport, doutput;

	if ((bMidiOption & 0b00001111) == 3) {
		/* 8ch Servo mode */
		for(i=0; i<8; i++) {
			if (bMidiVelocity[i] != 0) {
				bOutDuty[i] = (bMidiVelocity[i] / 4) + 10;
			}
		}
		PRT2GS = 0xff;
	}
	else {
		/* 8ch PWM */
		countbit = 0b00000001;
		setport = 0;
		doutput = 0;
		for(i=0; i<8; i++) {
			bOutDuty[i] = bMidiVelocity[i] << 1;
			if ((bOutDuty[i] == 0) || (bOutDuty[i] == 0xfe)) {
				if (bOutDuty[i] == 0xfe) {
					doutput |= countbit;
				}
			}
			else {
				setport |= countbit;
			}
			countbit <<= 1;
		}
		PRT2GS = setport;
		PRT2DR = doutput;
	}
	
	/* - set PWM */
	PWM8_3_WritePulseWidth(bOutDuty[0]);	
	PWM8_4_WritePulseWidth(bOutDuty[1]);	
	PWM8_5_WritePulseWidth(bOutDuty[2]);	
	PWM8_6_WritePulseWidth(bOutDuty[3]);	
	PWM8_7_WritePulseWidth(bOutDuty[4]);	
	PWM8_8_WritePulseWidth(bOutDuty[5]);	
	PWM8_9_WritePulseWidth(bOutDuty[6]);	
	PWM8_10_WritePulseWidth(bOutDuty[7]);	

}


/* --- I/O control */
void KanadeOutput(void)
{
	BYTE monoout;

	/* -- CN5 Poly */	
	PRT0DR = bMidiOutPoly;

	/* -- CN4 multi mode */
		if ((bPrevOption != bMidiOption) &&
		((bPrevOption & 0b00001111) < 2)) {
		/* full digital output */
		PRT2GS = 0x00;
	}
	monoout = bMidiMonoTone | (bMidiMonoTrigger <<7);
	switch(bMidiOption & 0b00001111) {
		/* - 0 = Monophonic mode */
		case 0:
			PRT2DR = monoout;
			break;
		/* - 1 = 8bit digital out mode */
		case 1:
			PRT2DR = bMidiOutPoly2;
			break;
		/* - 2 = 8ch PWM mode */
		/* - 3 = 8ch Servo mode */
		case 2:
		case 3:
			KanadePWM2();
			break;
		
		default:
			PRT2DR = monoout;
			break;
	}

	KanadePWM();

	bPrevOption = bMidiOption;
}

BYTE KanadeChannelRead(void)
{
	BYTE  p1;

	p1 = PRT1DR;
	if ((p1 & 0b00000001) == 1) {
		/* reset */
		MidiReset();
		bPrevOption = bMidiOption;
		PWM16_1_WritePeriod(2);
		PWM16_1_WritePulseWidth(2);\
	}
	p1 &= 0b00111100;
	p1 >>= 2;

	return(p1);
}



/* ------------------ */
/* - main routine     */
/* ------------------ */

void main(void)
{
	BYTE  midiChannel, chsw;

	/* module */
	PWM8_2_WritePeriod(23);
	PWM8_2_WritePulseWidth(11);
	PWM16_1_WritePeriod(2);
	PWM16_1_WritePulseWidth(2);
	PWM8_1_Start();
	PWM8_2_Start();
	PWM16_1_Start();
	RX8_1_Start( RX8_1_PARITY_NONE );
	PWM8_3_Start();
	PWM8_4_Start();
	PWM8_5_Start();
	PWM8_6_Start();
	PWM8_7_Start();
	PWM8_8_Start();
	PWM8_9_Start();
	PWM8_10_Start();
	
	/* work initialize */
	bReceivePointer = bProcessPointer = 0;
	bOutputFlag = bOutputTone = 0;

	midiChannel = KanadeChannelRead();
	SetMidiChannel(midiChannel);
	MidiReset();
	bPrevOption = bMidiOption;

	/* int */
	RX8_1_EnableInt();
	M8C_EnableGInt;

	while(1) {
		while(bReceivePointer == bProcessPointer) {}

		MidiReceive(bRxBuffer[bProcessPointer]);

		/* channel change */
		chsw = KanadeChannelRead();
		if (chsw != midiChannel) {
			midiChannel = chsw;
			SetMidiChannel(midiChannel);
			MidiReset();
		}

		/* next */
		bProcessPointer++;
		bProcessPointer &= (BUFFERSIZE-1);
 	}
}
