;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_9.inc
;;   Version: 2.5, Updated on 2009/10/15 at 17:11:37
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_9 API's.
;--------------------------------------------------

PWM8_9_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_9_INT_REG:                            equ 0x0df
PWM8_9_INT_MASK:                           equ 0x40


;--------------------------------------------------
; Constants for PWM8_9 user defined values
;--------------------------------------------------

PWM8_9_PERIOD:                             equ 0xff
PWM8_9_PULSE_WIDTH:                        equ 0x01


;--------------------------------------------------
; Register Address Constants for PWM8_9
;--------------------------------------------------

PWM8_9_COUNTER_REG:                    equ 0x58   ; DR0 Count register
PWM8_9_PERIOD_REG:                     equ 0x59   ; DR1 Period register
PWM8_9_COMPARE_REG:                    equ 0x5a   ; DR2 Compare register
PWM8_9_CONTROL_REG:                    equ 0x5b   ; Control register
PWM8_9_FUNC_REG:                       equ 0x58   ; Function register
PWM8_9_INPUT_REG:                      equ 0x59   ; Input register
PWM8_9_OUTPUT_REG:                     equ 0x5a   ; Output register


;--------------------------------------------------
; PWM8_9 Macro 'Functions'
;--------------------------------------------------

   macro PWM8_9_Start_M
   or    reg[PWM8_9_CONTROL_REG],  PWM8_9_CONTROL_REG_START_BIT
   endm

   macro PWM8_9_Stop_M
   and   reg[PWM8_9_CONTROL_REG], ~PWM8_9_CONTROL_REG_START_BIT
   endm

   macro PWM8_9_EnableInt_M
   M8C_EnableIntMask PWM8_9_INT_REG, PWM8_9_INT_MASK
   endm

   macro PWM8_9_DisableInt_M
   M8C_DisableIntMask PWM8_9_INT_REG, PWM8_9_INT_MASK
   endm


; end of file PWM8_9.inc
