//*****************************************************************************
//*****************************************************************************
//  FILENAME: PWM8_9.h
//   Version: 2.5, Updated on 2009/10/15 at 17:11:37
//  Generated by PSoC Designer 5.0.1127.0
//
//  DESCRIPTION: PWM8 User Module C Language interface file
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

#pragma fastcall16 PWM8_9_EnableInt
#pragma fastcall16 PWM8_9_DisableInt
#pragma fastcall16 PWM8_9_Start
#pragma fastcall16 PWM8_9_Stop
#pragma fastcall16 PWM8_9_bReadCounter              // Read  DR0
#pragma fastcall16 PWM8_9_WritePeriod               // Write DR1
#pragma fastcall16 PWM8_9_bReadPulseWidth           // Read  DR2
#pragma fastcall16 PWM8_9_WritePulseWidth           // Write DR2

// The following symbols are deprecated.
// They may be omitted in future releases
//
#pragma fastcall16 bPWM8_9_ReadCounter              // Read  DR0 (Deprecated)
#pragma fastcall16 bPWM8_9_ReadPulseWidth           // Read  DR2 (Deprecated)


//-------------------------------------------------
// Prototypes of the PWM8_9 API.
//-------------------------------------------------

extern void PWM8_9_EnableInt(void);                        // Proxy Class 1
extern void PWM8_9_DisableInt(void);                       // Proxy Class 1
extern void PWM8_9_Start(void);                            // Proxy Class 1
extern void PWM8_9_Stop(void);                             // Proxy Class 1
extern BYTE PWM8_9_bReadCounter(void);                     // Proxy Class 2
extern void PWM8_9_WritePeriod(BYTE bPeriod);              // Proxy Class 1
extern BYTE PWM8_9_bReadPulseWidth(void);                  // Proxy Class 1
extern void PWM8_9_WritePulseWidth(BYTE bPulseWidth);      // Proxy Class 1

// The following functions are deprecated.
// They may be omitted in future releases
//
extern BYTE bPWM8_9_ReadCounter(void);            // Deprecated
extern BYTE bPWM8_9_ReadPulseWidth(void);         // Deprecated


//--------------------------------------------------
// Constants for PWM8_9 API's.
//--------------------------------------------------

#define PWM8_9_CONTROL_REG_START_BIT           ( 0x01 )
#define PWM8_9_INT_REG_ADDR                    ( 0x0df )
#define PWM8_9_INT_MASK                        ( 0x40 )


//--------------------------------------------------
// Constants for PWM8_9 user defined values
//--------------------------------------------------

#define PWM8_9_PERIOD                          ( 0xff )
#define PWM8_9_PULSE_WIDTH                     ( 0x01 )


//-------------------------------------------------
// Register Addresses for PWM8_9
//-------------------------------------------------

#pragma ioport  PWM8_9_COUNTER_REG: 0x058                  //DR0 Count register
BYTE            PWM8_9_COUNTER_REG;
#pragma ioport  PWM8_9_PERIOD_REG:  0x059                  //DR1 Period register
BYTE            PWM8_9_PERIOD_REG;
#pragma ioport  PWM8_9_COMPARE_REG: 0x05a                  //DR2 Compare register
BYTE            PWM8_9_COMPARE_REG;
#pragma ioport  PWM8_9_CONTROL_REG: 0x05b                  //Control register
BYTE            PWM8_9_CONTROL_REG;
#pragma ioport  PWM8_9_FUNC_REG:    0x158                  //Function register
BYTE            PWM8_9_FUNC_REG;
#pragma ioport  PWM8_9_INPUT_REG:   0x159                  //Input register
BYTE            PWM8_9_INPUT_REG;
#pragma ioport  PWM8_9_OUTPUT_REG:  0x15a                  //Output register
BYTE            PWM8_9_OUTPUT_REG;
#pragma ioport  PWM8_9_INT_REG:       0x0df                //Interrupt Mask Register
BYTE            PWM8_9_INT_REG;


//-------------------------------------------------
// PWM8_9 Macro 'Functions'
//-------------------------------------------------

#define PWM8_9_Start_M \
   PWM8_9_CONTROL_REG |=  PWM8_9_CONTROL_REG_START_BIT

#define PWM8_9_Stop_M  \
   PWM8_9_CONTROL_REG &= ~PWM8_9_CONTROL_REG_START_BIT

#define PWM8_9_EnableInt_M   \
   M8C_EnableIntMask(PWM8_9_INT_REG, PWM8_9_INT_MASK)

#define PWM8_9_DisableInt_M  \
   M8C_DisableIntMask(PWM8_9_INT_REG, PWM8_9_INT_MASK)


// end of file PWM8_9.h
