;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_7.inc
;;   Version: 2.5, Updated on 2009/10/15 at 17:11:37
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_7 API's.
;--------------------------------------------------

PWM8_7_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_7_INT_REG:                            equ 0x0df
PWM8_7_INT_MASK:                           equ 0x10


;--------------------------------------------------
; Constants for PWM8_7 user defined values
;--------------------------------------------------

PWM8_7_PERIOD:                             equ 0xff
PWM8_7_PULSE_WIDTH:                        equ 0x01


;--------------------------------------------------
; Register Address Constants for PWM8_7
;--------------------------------------------------

PWM8_7_COUNTER_REG:                    equ 0x50   ; DR0 Count register
PWM8_7_PERIOD_REG:                     equ 0x51   ; DR1 Period register
PWM8_7_COMPARE_REG:                    equ 0x52   ; DR2 Compare register
PWM8_7_CONTROL_REG:                    equ 0x53   ; Control register
PWM8_7_FUNC_REG:                       equ 0x50   ; Function register
PWM8_7_INPUT_REG:                      equ 0x51   ; Input register
PWM8_7_OUTPUT_REG:                     equ 0x52   ; Output register


;--------------------------------------------------
; PWM8_7 Macro 'Functions'
;--------------------------------------------------

   macro PWM8_7_Start_M
   or    reg[PWM8_7_CONTROL_REG],  PWM8_7_CONTROL_REG_START_BIT
   endm

   macro PWM8_7_Stop_M
   and   reg[PWM8_7_CONTROL_REG], ~PWM8_7_CONTROL_REG_START_BIT
   endm

   macro PWM8_7_EnableInt_M
   M8C_EnableIntMask PWM8_7_INT_REG, PWM8_7_INT_MASK
   endm

   macro PWM8_7_DisableInt_M
   M8C_DisableIntMask PWM8_7_INT_REG, PWM8_7_INT_MASK
   endm


; end of file PWM8_7.inc
