;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_6.inc
;;   Version: 2.5, Updated on 2009/10/15 at 17:11:37
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_6 API's.
;--------------------------------------------------

PWM8_6_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_6_INT_REG:                            equ 0x0df
PWM8_6_INT_MASK:                           equ 0x08


;--------------------------------------------------
; Constants for PWM8_6 user defined values
;--------------------------------------------------

PWM8_6_PERIOD:                             equ 0xff
PWM8_6_PULSE_WIDTH:                        equ 0x01


;--------------------------------------------------
; Register Address Constants for PWM8_6
;--------------------------------------------------

PWM8_6_COUNTER_REG:                    equ 0x4c   ; DR0 Count register
PWM8_6_PERIOD_REG:                     equ 0x4d   ; DR1 Period register
PWM8_6_COMPARE_REG:                    equ 0x4e   ; DR2 Compare register
PWM8_6_CONTROL_REG:                    equ 0x4f   ; Control register
PWM8_6_FUNC_REG:                       equ 0x4c   ; Function register
PWM8_6_INPUT_REG:                      equ 0x4d   ; Input register
PWM8_6_OUTPUT_REG:                     equ 0x4e   ; Output register


;--------------------------------------------------
; PWM8_6 Macro 'Functions'
;--------------------------------------------------

   macro PWM8_6_Start_M
   or    reg[PWM8_6_CONTROL_REG],  PWM8_6_CONTROL_REG_START_BIT
   endm

   macro PWM8_6_Stop_M
   and   reg[PWM8_6_CONTROL_REG], ~PWM8_6_CONTROL_REG_START_BIT
   endm

   macro PWM8_6_EnableInt_M
   M8C_EnableIntMask PWM8_6_INT_REG, PWM8_6_INT_MASK
   endm

   macro PWM8_6_DisableInt_M
   M8C_DisableIntMask PWM8_6_INT_REG, PWM8_6_INT_MASK
   endm


; end of file PWM8_6.inc
