;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_5.inc
;;   Version: 2.5, Updated on 2009/10/15 at 17:11:37
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_5 API's.
;--------------------------------------------------

PWM8_5_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_5_INT_REG:                            equ 0x0df
PWM8_5_INT_MASK:                           equ 0x04


;--------------------------------------------------
; Constants for PWM8_5 user defined values
;--------------------------------------------------

PWM8_5_PERIOD:                             equ 0xff
PWM8_5_PULSE_WIDTH:                        equ 0x01


;--------------------------------------------------
; Register Address Constants for PWM8_5
;--------------------------------------------------

PWM8_5_COUNTER_REG:                    equ 0x48   ; DR0 Count register
PWM8_5_PERIOD_REG:                     equ 0x49   ; DR1 Period register
PWM8_5_COMPARE_REG:                    equ 0x4a   ; DR2 Compare register
PWM8_5_CONTROL_REG:                    equ 0x4b   ; Control register
PWM8_5_FUNC_REG:                       equ 0x48   ; Function register
PWM8_5_INPUT_REG:                      equ 0x49   ; Input register
PWM8_5_OUTPUT_REG:                     equ 0x4a   ; Output register


;--------------------------------------------------
; PWM8_5 Macro 'Functions'
;--------------------------------------------------

   macro PWM8_5_Start_M
   or    reg[PWM8_5_CONTROL_REG],  PWM8_5_CONTROL_REG_START_BIT
   endm

   macro PWM8_5_Stop_M
   and   reg[PWM8_5_CONTROL_REG], ~PWM8_5_CONTROL_REG_START_BIT
   endm

   macro PWM8_5_EnableInt_M
   M8C_EnableIntMask PWM8_5_INT_REG, PWM8_5_INT_MASK
   endm

   macro PWM8_5_DisableInt_M
   M8C_DisableIntMask PWM8_5_INT_REG, PWM8_5_INT_MASK
   endm


; end of file PWM8_5.inc
