//*****************************************************************************
//*****************************************************************************
//  FILENAME: PWM8_4.h
//   Version: 2.5, Updated on 2009/10/15 at 17:11:37
//  Generated by PSoC Designer 5.0.1127.0
//
//  DESCRIPTION: PWM8 User Module C Language interface file
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

#pragma fastcall16 PWM8_4_EnableInt
#pragma fastcall16 PWM8_4_DisableInt
#pragma fastcall16 PWM8_4_Start
#pragma fastcall16 PWM8_4_Stop
#pragma fastcall16 PWM8_4_bReadCounter              // Read  DR0
#pragma fastcall16 PWM8_4_WritePeriod               // Write DR1
#pragma fastcall16 PWM8_4_bReadPulseWidth           // Read  DR2
#pragma fastcall16 PWM8_4_WritePulseWidth           // Write DR2

// The following symbols are deprecated.
// They may be omitted in future releases
//
#pragma fastcall16 bPWM8_4_ReadCounter              // Read  DR0 (Deprecated)
#pragma fastcall16 bPWM8_4_ReadPulseWidth           // Read  DR2 (Deprecated)


//-------------------------------------------------
// Prototypes of the PWM8_4 API.
//-------------------------------------------------

extern void PWM8_4_EnableInt(void);                        // Proxy Class 1
extern void PWM8_4_DisableInt(void);                       // Proxy Class 1
extern void PWM8_4_Start(void);                            // Proxy Class 1
extern void PWM8_4_Stop(void);                             // Proxy Class 1
extern BYTE PWM8_4_bReadCounter(void);                     // Proxy Class 2
extern void PWM8_4_WritePeriod(BYTE bPeriod);              // Proxy Class 1
extern BYTE PWM8_4_bReadPulseWidth(void);                  // Proxy Class 1
extern void PWM8_4_WritePulseWidth(BYTE bPulseWidth);      // Proxy Class 1

// The following functions are deprecated.
// They may be omitted in future releases
//
extern BYTE bPWM8_4_ReadCounter(void);            // Deprecated
extern BYTE bPWM8_4_ReadPulseWidth(void);         // Deprecated


//--------------------------------------------------
// Constants for PWM8_4 API's.
//--------------------------------------------------

#define PWM8_4_CONTROL_REG_START_BIT           ( 0x01 )
#define PWM8_4_INT_REG_ADDR                    ( 0x0df )
#define PWM8_4_INT_MASK                        ( 0x02 )


//--------------------------------------------------
// Constants for PWM8_4 user defined values
//--------------------------------------------------

#define PWM8_4_PERIOD                          ( 0xff )
#define PWM8_4_PULSE_WIDTH                     ( 0x01 )


//-------------------------------------------------
// Register Addresses for PWM8_4
//-------------------------------------------------

#pragma ioport  PWM8_4_COUNTER_REG: 0x044                  //DR0 Count register
BYTE            PWM8_4_COUNTER_REG;
#pragma ioport  PWM8_4_PERIOD_REG:  0x045                  //DR1 Period register
BYTE            PWM8_4_PERIOD_REG;
#pragma ioport  PWM8_4_COMPARE_REG: 0x046                  //DR2 Compare register
BYTE            PWM8_4_COMPARE_REG;
#pragma ioport  PWM8_4_CONTROL_REG: 0x047                  //Control register
BYTE            PWM8_4_CONTROL_REG;
#pragma ioport  PWM8_4_FUNC_REG:    0x144                  //Function register
BYTE            PWM8_4_FUNC_REG;
#pragma ioport  PWM8_4_INPUT_REG:   0x145                  //Input register
BYTE            PWM8_4_INPUT_REG;
#pragma ioport  PWM8_4_OUTPUT_REG:  0x146                  //Output register
BYTE            PWM8_4_OUTPUT_REG;
#pragma ioport  PWM8_4_INT_REG:       0x0df                //Interrupt Mask Register
BYTE            PWM8_4_INT_REG;


//-------------------------------------------------
// PWM8_4 Macro 'Functions'
//-------------------------------------------------

#define PWM8_4_Start_M \
   PWM8_4_CONTROL_REG |=  PWM8_4_CONTROL_REG_START_BIT

#define PWM8_4_Stop_M  \
   PWM8_4_CONTROL_REG &= ~PWM8_4_CONTROL_REG_START_BIT

#define PWM8_4_EnableInt_M   \
   M8C_EnableIntMask(PWM8_4_INT_REG, PWM8_4_INT_MASK)

#define PWM8_4_DisableInt_M  \
   M8C_DisableIntMask(PWM8_4_INT_REG, PWM8_4_INT_MASK)


// end of file PWM8_4.h
