;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_10.inc
;;   Version: 2.5, Updated on 2009/10/15 at 17:11:37
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_10 API's.
;--------------------------------------------------

PWM8_10_CONTROL_REG_START_BIT:             equ 0x01    ; Control register start bit
PWM8_10_INT_REG:                           equ 0x0df
PWM8_10_INT_MASK:                          equ 0x80


;--------------------------------------------------
; Constants for PWM8_10 user defined values
;--------------------------------------------------

PWM8_10_PERIOD:                            equ 0xff
PWM8_10_PULSE_WIDTH:                       equ 0x01


;--------------------------------------------------
; Register Address Constants for PWM8_10
;--------------------------------------------------

PWM8_10_COUNTER_REG:                   equ 0x5c   ; DR0 Count register
PWM8_10_PERIOD_REG:                    equ 0x5d   ; DR1 Period register
PWM8_10_COMPARE_REG:                   equ 0x5e   ; DR2 Compare register
PWM8_10_CONTROL_REG:                   equ 0x5f   ; Control register
PWM8_10_FUNC_REG:                      equ 0x5c   ; Function register
PWM8_10_INPUT_REG:                     equ 0x5d   ; Input register
PWM8_10_OUTPUT_REG:                    equ 0x5e   ; Output register


;--------------------------------------------------
; PWM8_10 Macro 'Functions'
;--------------------------------------------------

   macro PWM8_10_Start_M
   or    reg[PWM8_10_CONTROL_REG],  PWM8_10_CONTROL_REG_START_BIT
   endm

   macro PWM8_10_Stop_M
   and   reg[PWM8_10_CONTROL_REG], ~PWM8_10_CONTROL_REG_START_BIT
   endm

   macro PWM8_10_EnableInt_M
   M8C_EnableIntMask PWM8_10_INT_REG, PWM8_10_INT_MASK
   endm

   macro PWM8_10_DisableInt_M
   M8C_DisableIntMask PWM8_10_INT_REG, PWM8_10_INT_MASK
   endm


; end of file PWM8_10.inc
