;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM16_1.inc
;;   Version: 2.5, Updated on 2009/10/15 at 17:11:37
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION: Assembler declarations for the PWM16 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM16_1 API's.
;--------------------------------------------------

PWM16_1_CONTROL_REG_START_BIT:             equ 0x01    ; Control register start bit
PWM16_1_INT_REG:                           equ 0x0e1
PWM16_1_INT_MASK:                          equ 0x40


;--------------------------------------------------
; Constants for PWM16_1 user defined values
;--------------------------------------------------

PWM16_1_PERIOD:                            equ 0x2bc
PWM16_1_PULSE_WIDTH:                       equ 0x15e


;--------------------------------------------------
; Register Address Constants for PWM16_1
;--------------------------------------------------

PWM16_1_COUNTER_LSB_REG:               equ 0x34   ; DR0 Count register
PWM16_1_COUNTER_MSB_REG:               equ 0x38
PWM16_1_PERIOD_LSB_REG:                equ 0x35   ; DR1 Period register
PWM16_1_PERIOD_MSB_REG:                equ 0x39
PWM16_1_COMPARE_LSB_REG:               equ 0x36   ; DR2 Compare register
PWM16_1_COMPARE_MSB_REG:               equ 0x3a
PWM16_1_CONTROL_LSB_REG:               equ 0x37   ; Control register
PWM16_1_CONTROL_MSB_REG:               equ 0x3b
PWM16_1_FUNC_LSB_REG:                  equ 0x34   ; Function register
PWM16_1_FUNC_MSB_REG:                  equ 0x38
PWM16_1_INPUT_LSB_REG:                 equ 0x35   ; Input register
PWM16_1_INPUT_MSB_REG:                 equ 0x39
PWM16_1_OUTPUT_LSB_REG:                equ 0x36   ; Output register
PWM16_1_OUTPUT_MSB_REG:                equ 0x3a


;--------------------------------------------------
; PWM16_1 Macro 'Functions'
;--------------------------------------------------

   macro PWM16_1_Start_M
   or    reg[PWM16_1_CONTROL_LSB_REG],  PWM16_1_CONTROL_REG_START_BIT
   endm

   macro PWM16_1_Stop_M
   and   reg[PWM16_1_CONTROL_LSB_REG], ~PWM16_1_CONTROL_REG_START_BIT
   endm

   macro PWM16_1_EnableInt_M
   M8C_EnableIntMask PWM16_1_INT_REG, PWM16_1_INT_MASK
   endm

   macro PWM16_1_DisableInt_M
   M8C_DisableIntMask PWM16_1_INT_REG, PWM16_1_INT_MASK
   endm


; end of file PWM16_1.inc

