/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   sound.pp                                             */
/*     ʰץ(SDL_mixer)                        */
/*                                                        */
/*--------------------------------------------------------*/
/* -- $Id: sound.pp,v 1.3 2002/08/10 03:05:14 rero2 Exp $ */

/*------------------------------------------------------------- */
/** @file
    @brief		ɥޥ͡
    @author		K.Kunikane (rerofumi)
    @since		Sep.04.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2002,2005 rerofumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include <stdio.h>
#include <string.h>

#include "SDL.h"
#include "SDL_Audio.h"
#include "SDL_mixer.h"

#include  "sound.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/*-------------------------------*/
/* local value                   */
/*-------------------------------*/

/* ----- BGM ȥå */
Mix_Music  *SoundTrack;
char  BGMPool[BGMMAX][256];

/* ----- BGM ȥå */
Mix_Chunk  *SEPool[SEMAX];

/* ----- ͭե饰 */
int  SoundEnable;

/* ----- ɥͥΥȥå */
int  track;

/* -------------------------------------------------------------- */
/* ---                                                    */
/* -------------------------------------------------------------- */

/* ---------------------------------------- */
/* --- ɤνȥꥹɤ߹       */
/* ---------------------------------------- */
void  SoundInit(void)
{
  int  i, num, l;
  int  ret;
  FILE *FIN;
  char line[256];
  char name[256];

  track = 0;

  /* ----- SDL_mixer Υץ */
  SoundEnable = TRUE;
  ret = Mix_OpenAudio(22050, AUDIO_S16, 2, 1024);
  if (ret != 0) {
    SoundEnable = FALSE;
#ifdef DEBUG
    printf("SDL mixer open failed.\n");
#endif   
    return;
  }

  /* ----- 󥯥ꥢ */
  for(i=0; i<BGMMAX; i++) {
    BGMPool[i][0] = 0;
  }
  for(i=0; i<SEMAX; i++) {
    SEPool[i] = 0;
  }

  /* ----- ɥꥹɤ߹ */
  FIN = fopen(SOUND_LIST_FILE, "r");
  if (FIN == NULL) {
    SoundEnable = FALSE;
#ifdef DEBUG
    printf("sound list open error.\n");
#endif   
    return;
  }
  while(feof(FIN) == FALSE) {
    fgets(line, 255, FIN);
    if (strlen(line) < 6) continue;
    if (line[0] == ' ') continue;
    if (line[0] == '#') continue;
    /* --- BGM list */
    if (line[0] == 'M') {
      num = (int)((line[1] - '0') * 100 + (line[2] - '0') * 10 + (line[3] - '0'));
      strcpy(name, (line + 5));
      l = strlen(name);
      if (name[l-1] == '\n') {
	name[l-1] = 0;
      }
      strcpy(BGMPool[num], name);
#ifdef DEBUG
    printf("BGM %d : %s\n", num, BGMPool[num]);
#endif   
    }
    /* --- SE list */
    if (line[0] == 'S') {
      num = (int)((line[1] - '0') * 100 + (line[2] - '0') * 10 + (line[3] - '0'));
      strcpy(name, (line + 5));
      l = strlen(name);
      if (name[l-1] == '\n') {
	name[l-1] = 0;
      }
      SEPool[num] = Mix_LoadWAV(name);
#ifdef DEBUG
      if (SEPool[num] != 0) {
	printf("SE %d : %s\n", num, name);
      }
      else{
	printf("SE read error.\n"); 
      }
#endif   
    }
  }
  fclose(FIN);
}


/* ---------------------------------------- */
/* --- ɤβ                       */
/* ---------------------------------------- */
void  SoundFree(void)
{
  int  i;

  if (SoundEnable == FALSE) {
    return;
  }
  /* ----- ݻɤβ */
  if (SoundTrack != 0) {
    Mix_HaltMusic();
    Mix_FreeMusic(SoundTrack);
    SoundTrack = 0;
  }
  /* ----- SEͥ */
  for(i=0; i<8; i++) {
    Mix_HaltChannel(i);
  }
  /* ----- SE chank β */
  for(i=0; i<SEMAX; i++) {
    if (SEPool[i] != 0) {
      Mix_FreeChunk(SEPool[i]);
      SEPool[i] = 0;
    }
  }
  /* ----- SDL_Mixer Υ */
  Mix_CloseAudio();
}


/* ---------------------------------------- */
/* --- BGM Υꥯ                     */
/* ---------------------------------------- */
void  SoundMusic(int req)
{
  if (SoundEnable == FALSE) {
    return;
  }
  /* --- ϰϥå */
  if (req < 0) return;
  if (req >= BGMMAX) return;
  if (BGMPool[req][0] == 0) return;
  /* ----- ޤǤα */
  if (SoundTrack != 0) {
    Mix_HaltMusic();
    Mix_FreeMusic(SoundTrack);
    SoundTrack = 0;
  }
  /* ----- BGM ճ */
  SoundTrack = Mix_LoadMUS(BGMPool[req]);
  if (SoundTrack == NULL) {
    SoundTrack = 0;
    return;
  }
  Mix_PlayMusic(SoundTrack, -1);
}

/* ---------------------------------------- */
/* --- ֤ʤ BGM Υꥯ        */
/* ---------------------------------------- */
void  SoundMusicOneshot(int  req)
{
  if (SoundEnable == FALSE) {
    return;
  }
  /* --- ϰϥå */
  if (req < 0) return;
  if (req >= BGMMAX) return;
  if (BGMPool[req][0] == 0) return;
  /* ----- ޤǤα */
  if (SoundTrack != 0) {
    Mix_HaltMusic();
    Mix_FreeMusic(SoundTrack);
    SoundTrack = 0;
  }
  /* ----- BGM ճ */
  SoundTrack = Mix_LoadMUS(BGMPool[req]);
  if (SoundTrack == NULL) {
    SoundTrack = 0;
    return;
  }
  Mix_PlayMusic(SoundTrack, 1);
}


/* ---------------------------------------- */
/* --- SE Υꥯ                      */
/* ---------------------------------------- */
void  SoundSE(int req)
{
  if (SoundEnable == FALSE) return;
  /* --- ϰϥå */
  if (req < 0) return;
  if (req >= BGMMAX) return;
  if (SEPool[req] == 0) return;
  /* ----- SE ȯ */
  Mix_PlayChannel(track, SEPool[req], 0);
  track = (track + 1) % 8;
}

/* ---------------------------------------- */
/* --- BGM ȥå                   */
/* ---------------------------------------- */
void  SoundMusicStop(void)
{
  if (SoundEnable == FALSE) {
    return;
  }
  /* --- */
  Mix_HaltMusic();
}

/* ---------------------------------------- */
/* --- SE                           */
/* ---------------------------------------- */
void  SoundSEStop(void)
{
  int i;

  if (SoundEnable == FALSE) {
    return;
  }
  /* --- */
  /* ----- SEͥ */
  for(i=0; i<8; i++) {
    Mix_HaltChannel(i);
  }
}


