/* ---------------------------------------------------------- */
/*  puz_disp.h                                                */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   puz_disp.h                                           */
/*     ѥɽ                                 */
/*                                                        */
/*--------------------------------------------------------*/

#ifndef PUZ_DISP_H
#define PUZ_DISP_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "grp_screen.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* --- ɽط */
#define OBJMAX   186
#define TEXMAX   5
#define FIELDTOP 4
#define KIRAMAX  36


enum GameMode {
  MODE_CHALLENGE,
  MODE_1P,
  MODE_2P
};


/*-------------------------------*/
/* struct                        */
/*-------------------------------*/

/* -------------------------------- */
/* --- 餭饨ե */
typedef struct {
  /* - ɽå */
  int  DispSw;
  /* - ɽ֥Ȥݻ */
  TGameSprite *obj;
  /* - ɽ֥ޡ */
  int timer;
  /* - ä */
  int timer_end;
  /* - ɽ */
  int  x;
  int  y;
  /* - ư */
  int  dx;
  int  dy;
} Kira, *PKira;

/* -------------------------------- */
/* --- طʤΥ̥ɸ */
typedef struct {
  int  x, y;
} TanuPos, PTanuPos;


/* -------------------------------- */
/* --- 饹С */
typedef struct {
  /* - ƥ饹 */
  TPuzzleBase  *super;
  /* - ⡼ */
  int  puz_mode;
  /* - ɽֻ */
  int  fieldpos_x;
  /* - ɽѥ֥ȥݥ󥿡 */
  TGameSprite  *obj[OBJMAX];
  /* - ƥ㡼ݥ󥿡 */
  SDL_Surface  *texture[TEXMAX];
  /* --- private */
  /* - 餭饨ե */
  Kira  kirakira[KIRAMAX];
  /* - ̥ɽ */
  TanuPos  tanuki[4];
  /* - ꡼ݻ */
  TGameScreen  *screen;
  /* - ɽѥޡ */
  int  disptimer;
} TPuzzleDisp, *PTPuzzleDisp;


/* ---------------------------------------------- */
/* --- extern                                  -- */
/* ---------------------------------------------- */

TPuzzleDisp *TPuzzleDisp_Create(int  mode, TGameScreen *scr);
void TPuzzleDisp_Destroy(TPuzzleDisp *class);

void TPuzzleDisp_DispField(TPuzzleDisp *class);
void TPuzzleDisp_DispReady(TPuzzleDisp *class, int time);
void TPuzzleDisp_DispGameover(TPuzzleDisp *class, int time);
void TPuzzleDisp_DispClear(TPuzzleDisp *class);
void TPuzzleDisp_KiraRequest(TPuzzleDisp *class,
			     int x, int y, int l);



#endif //PUZ_DISP_H
