/* ---------------------------------------------------------- */
/*  grp_texture.c                                             */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   grp_texture.c                                        */
/*     eNX`[ǗNX                             */
/*                                                        */
/*--------------------------------------------------------*/

/*------------------------------------------------------------- */
/** @file
    @brief		eNX`[Ǘ
    @author		K.Kunikane (rerofumi)
    @since		Sep.19.2005
*/
/*-----------------------------------------------------
 Copyright (C) 2002,2005 rerofumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "SDL.h"
#include "grp_texture.h"


/*-------------------------------*/
/* local value                   */
/*-------------------------------*/

/*-------------------------------*/
/* local function                */
/*-------------------------------*/

/* -------------------------------------------------------------- */
/* --- eNX`ǗNX                                       */
/* -------------------------------------------------------------- */

/* ---------------------------------------- */
/* --- RXgN^EfXgN^         */
void TGameTexture_Create(TGameTexture *class)
{
  int  i;
  if (class == NULL) {
    return;
  }
  for(i=0; i<TEXTUREMAX; i++) {
    class->bitmap[i] = NULL;
  }
}

void TGameTexture_Destroy(TGameTexture *class)
{
  int  i;
  if (class == NULL) {
    return;
  }

  /* ----- [h̃eNX` */
  for(i=0; i<TEXTUREMAX; i++) {
    if (class->bitmap[i] != NULL) {
      SDL_FreeSurface(class->bitmap[i]);
      class->bitmap[i] = NULL;
    }
  }
}


/* ---------------------------------------- */
/* --- eNX`[̓ǂݍ݁Ao^         */
/* ---------------------------------------- */
void TGameTexture_Load(TGameTexture *class,
		       int num,
		       char *filename,
                       SDL_Surface *GameScreen,
                       int preconv)
{
  SDL_Surface  *plane;

  if (class == NULL) {
    return;
  }

  /* ----- eNX`ԍsI */
  if (num < 0) return;
  if (num > TEXTUREMAX) return;

  /* ----- ɃeNX` */
  if (class->bitmap[num] != NULL) {
    SDL_FreeSurface(class->bitmap[num]);
    class->bitmap[num] = NULL;
  }

  /* ----- eNX`[̓ǂݍ */
  plane = IMG_Load(filename);
  if (plane == NULL) {
    class->bitmap[num] = NULL;
    return;
  }
  if (preconv == TRUE) {
    class->bitmap[num] = SDL_ConvertSurface(plane,
					    GameScreen->format,
					    SDL_SWSURFACE);
    if (plane != NULL) {
      SDL_FreeSurface(plane);
    }
  }
  else {
    class->bitmap[num] = plane;
  }
}


/* ---------------------------------------- */
/* --- eNX`[̓n                   */
/* ---------------------------------------- */
SDL_Surface  *TGameTexture_GetTexture(TGameTexture *class,
				      int index)
{

  if (class == NULL) {
    return(NULL);
  }
  return(class->bitmap[index]);
}
