/* ---------------------------------------------------------- */
/*  grp_screen.h                                              */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   debug.pp                                             */
/*     ǥХåѥå롼                         */
/*                                                        */
/*--------------------------------------------------------*/
/* -- $Id: debug.pp,v 1.3 2002/07/11 17:21:47 rero2 Exp $ */


/*------------------------------------------------------------- */
/** @file
    @brief		ǥХåå롼
    @author		K.Kunikane (rerofumi)
    @since		Jul.27.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2002,2005 rerofumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/


#ifndef GRP_SCREEN_H
#define GRP_SCREEN_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "SDL.h"

#include "grp_texture.h"
#include "grp_sprite.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/* --- 祹ץ饤ȿ */
#define  SPRITEMAX  512

/*-------------------------------*/
/* struct                        */
/*-------------------------------*/

typedef struct {
  SDL_Surface *Screen;
  TGameTexture Texture;
  TGameSprite  Sprites[SPRITEMAX];
  int Width;
  int Height;
  int Depth;
} TGameScreen, *PTGameScreen;


/* ---------------------------------------------- */
/* --- extern                                  -- */
/* ---------------------------------------------- */

void TGameScreen_Create(TGameScreen *class, int width, int height, int depth);
void TGameScreen_Destroy(TGameScreen *class);
void TGameScreen_SetWMName(TGameScreen *class, char *name);
void TGameScreen_DispScreen(TGameScreen *class);
void TGameScreen_RefreshScreen(TGameScreen *class);

TGameSprite *TGameScreen_GetSprite(TGameScreen *class, int id);
SDL_Surface *TGameScreen_GetTexture(TGameScreen *class, int id);
void TGameScreen_LoadTexture(TGameScreen *class, int num, char *filename);
void TGameScreen_LoadTexturePure(TGameScreen *class, int num, char *filename);


#endif //GRP_SCREEN_H






