/* ---------------------------------------------------------- */
/*  debug.c                                                   */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   grp_screen.c                                         */
/*     ʊǗNX                                     */
/*                                                        */
/*--------------------------------------------------------*/
/* -- $Id: debug.pp,v 1.3 2002/07/11 17:21:47 rero2 Exp $ */


/*------------------------------------------------------------- */
/** @file
    @brief		`XN[Ǘ
    @author		K.Kunikane (rerofumi)
    @since		Jul.27.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2002,2005 rerofumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include <stdlib.h>

#include "grp_screen.h"

#include "debug.h"


/*-------------------------------*/
/* local value                   */
/*-------------------------------*/

/*-------------------------------*/
/* local function                */
/*-------------------------------*/

/* --- XvCgꖇXN[ɓ\t */
void Render(TGameScreen *class, TGameSprite *spr);


/* -------------------------------------------------------------- */
/* --- XN[ǗNX                                       */
/* -------------------------------------------------------------- */

/* ---------------------------------------- */
/* --- RXgN^EfXgN^         */
void TGameScreen_Create(TGameScreen *class, int width, int height, int depth)
{
  int  i;

  /* ----- XN[̐ */
  class->Screen = SDL_SetVideoMode(width, height, depth, SDL_SWSURFACE);
  TGameTexture_Create(&class->Texture);
  class->Width = width;
  class->Height = height;
  class->Depth = depth;
  /* ---  */
  for(i=0; i<SPRITEMAX; i++) {
    TGameSprite_Create(&class->Sprites[i]);
  }
}

void TGameScreen_Destroy(TGameScreen *class)
{
  /* ----- eNX`̉ */
  TGameTexture_Destroy(&class->Texture);
  /* ----- XN[̉ */
  SDL_FreeSurface(class->Screen);
}

/* ---------------------------------------- */
/* --- EBhE^Cg̐ݒ             */
void TGameScreen_SetWMName(TGameScreen *class, char *name)
{
  SDL_WM_SetCaption(name, name);
}


/* ---------------------------------------- */
/* --- t[^C~OɂS`       */
void TGameScreen_DispScreen(TGameScreen *class)
{
  int  i;

  /* --- XvCg` */
  for(i=0; i<SPRITEMAX; i++) {
    if ((class->Sprites[i].DispSw == TRUE) &&
	(class->Sprites[i].Texture != NULL)) {
      Render(class, &class->Sprites[i]);
    }
  }
}

void TGameScreen_RefreshScreen(TGameScreen *class)
{
  /* --- XN[Abvf[g */
  SDL_UpdateRect(class->Screen, 0, 0, class->Width, class->Height);
  /* --- SNA */
#ifdef NOTPSP
  SDL_FillRect(class->Screen, 0, 0xff000040);
#else
  SDL_FillRect(class->Screen, 0, 0xff400000);
#endif
}


/* ---------------------------------------- */
/* --- eNX`[h               */

void TGameScreen_LoadTexture(TGameScreen *class,
			     int num,
			     char *filename)
{
  TGameTexture_Load(&class->Texture, num, filename, class->Screen, TRUE);
}

void TGameScreen_LoadTexturePure(TGameScreen *class,
				 int num,
				 char *filename)
{
  TGameTexture_Load(&class->Texture, num, filename, class->Screen, FALSE);
}


/* ---------------------------------------- */
/* --- XvCgn                     */
TGameSprite *TGameScreen_GetSprite(TGameScreen *class, int id)
{
  if (id < 0) return(0);
  if (id > SPRITEMAX) return(0);

  return(&(class->Sprites[id]));
}


/* ---------------------------------------- */
/* --- eNX`n                     */
SDL_Surface *TGameScreen_GetTexture(TGameScreen *class, int id)
{
  return(TGameTexture_GetTexture(&class->Texture, id));
}


/* ---------------------------------------- */
/* --- XvCg̕\(ʓ])           */
void Render(TGameScreen *class, TGameSprite *spr)
{
  unsigned char  org_alpha;
  SDL_Rect  rect1, rect2;
  int  r;

  /* --- \XCb` */
  if (spr->DispSw == FALSE) return;
  if (spr->Texture == NULL) return;

  /* --- \͈ */
  rect1.w = spr->w;
  rect1.h = spr->h;
  rect2.w = spr->w;
  rect2.h = spr->h;
  rect1.x = spr->tx;
  rect1.y = spr->ty;
  rect2.x = spr->x;
  rect2.y = spr->y;
  org_alpha = spr->Texture->format->alpha;
  if (org_alpha != spr->alpha) {
    if (spr->alpha < 255) {
      SDL_SetAlpha(spr->Texture, SDL_SRCALPHA, spr->alpha);
    }
    else {
      SDL_SetAlpha(spr->Texture, 0, 0);
    }
  }
  r = SDL_BlitSurface(spr->Texture, &rect1, class->Screen, &rect2);
  if (org_alpha != spr->alpha) {
    SDL_SetAlpha(spr->Texture, SDL_SRCALPHA, org_alpha);
  }
}


