/* ---------------------------------------------------------- */
/*  gamemain.c                                                */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   gamemain.c                                           */
/*     Q[{̂̃Ct[                           */
/*                                                        */
/*--------------------------------------------------------*/

/*------------------------------------------------------------- */
/** @file
    @brief		Q[{̃Xebv
    @author		K.Kunikane (rerofumi)
    @since		Sep.20.2005
*/
/*-----------------------------------------------------
 Copyright (C) 2002,2005 rerofumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include <stdlib.h>
#include <math.h>

#include "gamemain.h"
#include "input.h"
#include "sound.h"
#include "debug.h"
#include "puz_trial.h"

/*-------------------------------*/
/* local value                   */
/*-------------------------------*/

/*-------------------------------*/
/* local function                */
/*-------------------------------*/

/* -------------------------------------------------------------- */
/* --- Q[CXebv                                       */
/* -------------------------------------------------------------- */

/* ---------------------------------------- */
/* --- RXgN^EfXgN^         */
void TGameMain_Create(TGameMain *class, TGameScreen *mainscreen)
{
  if (class == NULL) return;

  class->screen = mainscreen;
  class->step = TitleInit;
}

void TGameMain_Destroy(TGameMain *class)
{
  if (class == NULL) return;
  /* ɂȂ */
}


/* ---------------------------------------- */
/* --- Q[C                         */
/* ---------------------------------------- */
int TGameMain_Poll(TGameMain *class,
		    int counter)
{
  int  i;
  int  skip;
  TGameSprite  *sp;

  if (class == NULL) return(FALSE);

  skip = TRUE;

  /* -------------------------------- */
  /* --- Q[CXebv */
  
  switch(class->step) {

    /* -- ^Cg */
  case TitleInit:
    TGameScreen_LoadTexture(class->screen, 0, "title01.png");
    TGameScreen_LoadTexturePure(class->screen, 1, "title02.png");
    class->bg = TGameScreen_GetSprite(class->screen, 0);
    class->logo = TGameScreen_GetSprite(class->screen, 1);
    class->push = TGameScreen_GetSprite(class->screen, 2);
    class->release = TGameScreen_GetSprite(class->screen, 3);
    class->bg->DispSw = TRUE;
    class->bg->x = 0;
    class->bg->y = 0;
    class->bg->w = 480;
    //class->bg->h = 360;
    class->bg->h = 272;
    class->bg->tx = 0;
    class->bg->ty = 0;
    class->bg->Texture = TGameScreen_GetTexture(class->screen, 0);
    class->bg->alpha = 255;
    class->logo->DispSw = FALSE;
    class->logo->x = 0;
    class->logo->y = 0;
    class->logo->w = 400;
    class->logo->h = 112;
    class->logo->tx = 0;
    class->logo->ty = 0;
    class->logo->Texture = TGameScreen_GetTexture(class->screen, 1);
    class->logo->alpha = 255;
    class->push->DispSw = FALSE;
    class->push->x = 80;
    class->push->y = 200;
    class->push->w = 320;
    class->push->h = 30;
    class->push->tx = 0;
    class->push->ty = 114;
    class->push->Texture = TGameScreen_GetTexture(class->screen, 1);
    class->push->alpha = 255;
    class->release->DispSw = FALSE;
    class->release->x = 80;
    class->release->y = 240;
    class->release->w = 320;
    class->release->h = 16;
    class->release->tx = 0;
    class->release->ty = 144;
    class->release->Texture = TGameScreen_GetTexture(class->screen, 1);
    class->release->alpha = 255;
    class->titletimer = 0;
    class->step = TitleIn;
    skip = FALSE;
    break;

    /* -- ^CgSt[C */
  case TitleIn:
    /* - SE */
    if (class->titletimer == 15) SoundSE(1);
    if (class->titletimer > 20) {
      /* ͂ */
      class->logo->x = 38;
      class->logo->y = 120 - (int)(sin(3.1415926 * 2.0 * (((float)class->titletimer - 20.0) / 60.0)) * 120.0);
      class->logo->DispSw = TRUE;
    }
    else {
      /* ォ~Ă */
      class->logo->x = 38;
      class->logo->y = 120 - ((20 - class->titletimer) * 20);
      class->logo->DispSw = TRUE;
    }
    /* -- ֐iރXebv */
    class->titletimer = class->titletimer + 1;
    if (class->titletimer == 38) {
      SoundSE(6);
    }
    if (class->titletimer == 45) {
      SoundMusic(2);
      class->step = TitleMain;
    }
    i = InputJoyKeyTriger(0);
    if ((i & IN_Button1) != 0) {
      SoundMusic(2);
      class->step = TitleMain;
    }
    break;

    /* -- X^[g{^҂ */
  case TitleMain:
    class->logo->DispSw = TRUE;
    class->logo->x = 38;
    class->logo->y = 60;
    class->release->DispSw = TRUE;
    if (((class->titletimer / 4) % 2) == 1) {
      class->push->DispSw = TRUE;
    }
    else {
      class->push->DispSw = FALSE;
    }
    class->titletimer = class->titletimer + 1;
    i = InputJoyKeyTriger(0);
    if ((i & IN_Button1) != 0) {
      SoundSE(2);
      class->titletimer = 0;
      class->step = TitleStart;
    }
    break;

    /* -- X^[gAgNg */
  case TitleStart:
    class->logo->DispSw = TRUE;
    class->logo->x = 38;
    class->logo->y = 60;
    class->release->DispSw = TRUE;
    if ((class->titletimer % 2) == 1) {
      class->push->DispSw = TRUE;
    }
    else {
      class->push->DispSw = FALSE;
    }
    class->titletimer = class->titletimer + 1;
    if (class->titletimer == 20) {
      SoundMusicStop();
      class->step = TitleFree;
    }
    break;

    /* -- ^CgSサ܂ */
  case TitleFree:
    srand(counter);
    class->bg->DispSw = FALSE;
    class->logo->DispSw = FALSE;
    class->push->DispSw = FALSE;
    class->release->DispSw = FALSE;
    class->step = PuzzleInit;
    break;


    /* -- Q[ */
  case PuzzleInit:
    class->puzzle = TPuzzleTrial_Create(class->screen);
    class->step = PuzzleMain;
    skip = FALSE;
    break;

    /* -- Q[C */
  case PuzzleMain:
    TPuzzleTrial_GameMain(class->puzzle);
    if (TPuzzleTrial_GameStat(class->puzzle) == FALSE) {
      class->step = PuzzleFree;
    }
    break;

    /* -- Q[Iサ܂ */
    case PuzzleFree:
      TPuzzleTrial_Destroy(class->puzzle);
      for( i=0; i<SPRITEMAX; i++) {
	sp = TGameScreen_GetSprite(class->screen, i);
	sp->DispSw = FALSE;
      }
      class->step = TitleInit;
      break;
  } // switch

  return(skip);
}
