/* ---------------------------------------------------------- */
/*  debug.h                                                   */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   debug.pp                                             */
/*     ǥХåѥå롼                         */
/*                                                        */
/*--------------------------------------------------------*/
/* -- $Id: debug.pp,v 1.3 2002/07/11 17:21:47 rero2 Exp $ */


/*------------------------------------------------------------- */
/** @file
    @brief		ǥХåå롼
    @author		K.Kunikane (rerofumi)
    @since		Jul.27.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2002,2005 rerofumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/


#ifndef DEBUG_H
#define DEBUG_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "SDL.h"

#include "grp_screen.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/* ----- åɽ */
#define  MessageMax  20

#if (SDL_BYTEORDER == SDL_BIG_ENDIAN)
 #define Rmask 0xff000000
 #define Gmask 0x00ff0000
 #define Bmask 0x0000ff00
 #define Amask 0x000000ff
#else
 #define Rmask 0x000000ff
 #define Gmask 0x0000ff00
 #define Bmask 0x00ff0000
 #define Amask 0xff000000
#endif

/*-------------------------------*/
/* struct                        */
/*-------------------------------*/

extern char debug_line[128];

/* ---------------------------------------------- */
/* --- extern                                  -- */
/* ---------------------------------------------- */

void  TDebugInit(TGameScreen *screen,
		int Width, int Height, int Depth);
void  TDebugFree(void);
void  TDebugDisp(TGameScreen *screen);
void  TDebugPrint(char *mes);
void  IntToStr(int num, char *buf);
void  IntToHex(int num, int length, char *buf);

#endif //DEBUG_H
