/**
 *  --- SDL puzzle project 'tailtale'.
 *
 */

#include <stdlib.h>

#include "SDL.h"
#include "SDL_main.h"
#include "SDL_Audio.h"
#include "SDL_mixer.h"

#include "bootmain.h"
#include "debug.h"
#include "input.h"
#include "sound.h"
#include "grp_screen.h"
#include "gamemain.h"

TGameScreen  scr;
TGameMain    puzmain;

/* --------------------------------------------- */
/* --- C[`                        --- */
/* --------------------------------------------- */
int  main(int argc, char *argv[])
{
  int  i;
  /* --- C[`[vtO */
  int  endflag;
  /* --- ^CJEg */
  int  SystemTime;
  int  BeforeTiming;
  int  NowTiming;
  int  WorkTime;
  int FrameCounter;
  int  FrameSkip;

  WorkTime = 0;
  FrameSkip = 0;

  /* ----- SDL  */
  i = SDL_Init(SDL_INIT_VIDEO | 
	       SDL_INIT_AUDIO | 
	       SDL_INIT_TIMER |
	       SDL_INIT_JOYSTICK );
  if (i != 0) {
    /* --- SDLłȂ */
#ifdef DEBUG
    printf("SDL initialize error.\n");
#endif
    exit(-1);
  }

  /* --- ItO */
  endflag = 0;

  /* ----- n[hEFA */
  InputInit();
  SoundInit();
  TGameScreen_Create(&scr,
  		     SCREEN_WIDTH, SCREEN_HEIGHT,
  		     SCREEN_DEPTH);
  TGameScreen_SetWMName(&scr, WindowName);
  SystemTime = SDL_GetTicks();
  BeforeTiming = SystemTime;
  FrameCounter = 0;
  srand(1);

  /* ----- fobO[` */
#ifdef DEBUG
  TDebugInit(&scr, SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_DEPTH);
#endif
  
  /* ----- Q[{̏ */
  TGameMain_Create(&puzmain, &scr);

  /* ---------------------------------------- */
  /* ----- C[`                     */
  /* ---------------------------------------- */
  while(endflag == 0) {
    for(i=0; i<=FrameSkip; i++) {
      /* --- Q[{̃[v */
      FrameCounter = FrameCounter + 1;
      InputPoll();
      /* ------------------------------- */
      /* ----- Q[C */
      if (TGameMain_Poll(&puzmain, FrameCounter) == FALSE) {
	BeforeTiming = SDL_GetTicks();
	break;
      }
    }

    /* --- t[IAXN[` */
    TGameScreen_DispScreen(&scr);
#ifdef DEBUG
    snprintf(debug_line, 127, "%d", FrameCounter);
    TDebugPrint(debug_line);
    snprintf(debug_line, 127, "Work Time : %d/%d", WorkTime, (1000/FRAME_RATE));
    TDebugPrint(debug_line);
    snprintf(debug_line, 127, "Frame Skip : %d", FrameSkip);
    TDebugPrint(debug_line);
    snprintf(debug_line, 127, "Key Input : %d", InputJoyKey(0));
    TDebugPrint(debug_line);

    TDebugDisp(&scr);
#endif
    TGameScreen_RefreshScreen(&scr);
    /* --- t[^C}[ */
    WorkTime = SDL_GetTicks() - BeforeTiming;
    NowTiming = (1000 / FRAME_RATE) - WorkTime;
    if ((NowTiming > 0) && (NowTiming <= (1000 / FRAME_RATE))) {
      SDL_Delay(NowTiming);
      endflag = InputExit();
    }
    FrameSkip = WorkTime / (1000 / FRAME_RATE);
    BeforeTiming = SDL_GetTicks();

    /* ---------------------------------------- */
    /* ----- C[vRR܂               */
  }

#ifdef DEBUG
  TDebugFree();
#endif

  /* --- XN[ */
  TGameScreen_Destroy(&scr);
  /* --- IASDL ㏈ */
  SoundFree();
  InputFree();
  SDL_Quit();

  return(0);
}

