/* ---------------------------------------------------------- */
/*  puz_base.h                                                */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   puz_base.h                                           */
/*     ѥ                                   */
/*                                                        */
/*--------------------------------------------------------*/

#ifndef PUZ_BASE_H
#define PUZ_BASE_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* --- ֥å */
#define BLOCK_WIDTH  24
#define BLOCK_HEIGHT  24

/* --- եɥ */
#define FIELD_WIDTH  8
/* Next  */
#define FIELD_HEIGHT  11
#define ALL_BLOCK  (FIELD_WIDTH * FIELD_HEIGHT)

/* --- ĤǾä뤫 */
#define  LINE_LENGTH  4


enum GamePhase {
  STEP_PAUSE,
  STEP_NORMAL,
  STEP_SWAP,
  STEP_LINECHECK,
  STEP_LINEFLASH,
  STEP_LINEERASE,
  STEP_DROPCHECK,
  STEP_DROPWORK,
  STEP_END
};

enum MoveDir {
  MOVE_UP,
  MOVE_DOWN,
  MOVE_LEFT,
  MOVE_RIGHT
};

enum SwapFlag {
  SWAP_NONE,
  SWAP_MASTER,
  SWAP_SLAVE
};

/* ---  */
enum {
  LevelEasy = 0,
  LevelNormal,
  LevelHard
} GameLevel;



/*-------------------------------*/
/* struct                        */
/*-------------------------------*/

typedef struct {
  /* --- ֥åμ(0¸ߤ) */
  int  Color;
  /* --- ·ȽԤݤΥե饰 */
  int  LineCheck;
  /* --- ·ä֥åǤե饰 */
  int  LineBlock;
  /* --- ·äƤtimer */
  int  LineTimer;
  /* --- 夲timer */
  int  PopupTimer;
  /* --- 夲֥եå*/
  int  PopupOffset;
  /* --- ֥åǤ뤳ȤΥե饰 */
  int  DropCheck;
  /* --- 륢˥᡼timer */
  int  DropTimer;
  /* --- 륢˥᡼Υեå */
  int  DropOffset;
  /* --- ؤե饰(ؤɤ) */
  int  SwapSide; 
  /* --- ؤtimer */
  int  SwapTimer;
  /* --- ؤ֥եå */
  int  SwapOffsetX;
  int  SwapOffsetY;
} Block, *PBlock;


typedef struct {
  /* --- ֥åɸŪ */
  int  X;
  int  Y;
  /* --- ֥åĤǤ뤫ݤ */
  int  HaveBlock;
  /* --- ؤtimer */
  int  SwapTimer;
  /* --- ؤ֥եå */
  int  SwapOffsetX;
  int  SwapOffsetY;
  /* --- ֥å夬ɿ */
  int  PopupTimer;
  int  PopupOffset;
} Cursor, *PCursor;


typedef struct {
  int  GameTimer;
  /* --- 饹 */
  /* - ॹƥå */
  int  GameStep;
  /* - ץ쥤䡼 */
  Cursor  UA;
  /* - ֥åξ */
  Block  Item[FIELD_WIDTH * FIELD_HEIGHT];
  /* - եɤξ */
  Block *Field[FIELD_WIDTH * FIELD_HEIGHT];
  /* - ֥å顼(鿧Ƭ) */
  int  BlockColor[7];
  /* - ֥å顼 */
  int  ColorNum;
  /* - ͥȤޤǤΥ */
  int  NextInterval;
  /* - ͥȤtimer */
  int  NextTimer;
  /* - ٥ */
  int  Level;
  /* - 饯顼(֥åο˱ƶ) */
  int  CharaColor;
  /* - ˥᡼ե饰(ΤưߤޤäƤfalse) */
  int  Animation;
  /* - ֥åä */
  int  EraseBlock;
  /* - ä֥åˤ */
  int  EraseScore;
  /* -  */
  int  Score;
  /* - Ϣ */
  int  Combo;
  /* - ४Сե饰 */
  int  GameOver;
  /* - Τ  */
  int  Difficult;
} TPuzzleBase, *PTPuzzleBase;

/* ---------------------------------------------- */
/* --- extern                                  -- */
/* ---------------------------------------------- */

TPuzzleBase *TPuzzleBase_Create(int difficult);
void TPuzzleBase_Destroy(TPuzzleBase *class);

void TPuzzleBase_GameInit(TPuzzleBase *class, int col);
void TPuzzleBase_GameExec(TPuzzleBase *class);
void TPuzzleBase_GamePause(TPuzzleBase *class, int mode);
void TPuzzleBase_GameLevel(TPuzzleBase *class, int lset);
int  TPuzzleBase_LevelCheck(TPuzzleBase *class);
int  TPuzzleBase_MoveRequest(TPuzzleBase *class,
			     int posx, int posy,
			     int dir);



#endif //GRP_SPRITE_H
