/* ---------------------------------------------------------- */
/*  grp_sptite.c                                              */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   grp_sprite.c                                         */
/*     XvCgǗ\                               */
/*                                                        */
/*--------------------------------------------------------*/

/*------------------------------------------------------------- */
/** @file
    @brief		XvCgǗ
    @author		K.Kunikane (rerofumi)
    @since		Sep.19.2005
*/
/*-----------------------------------------------------
 Copyright (C) 2002,2005 rerofumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include <stdlib.h>

#include "SDL.h"
#include "grp_sprite.h"


/*-------------------------------*/
/* local value                   */
/*-------------------------------*/

/*-------------------------------*/
/* local function                */
/*-------------------------------*/

/* -------------------------------------------------------------- */
/* --- eNX`ǗNX                                       */
/* -------------------------------------------------------------- */

/* ---------------------------------------- */
/* --- RXgN^EfXgN^         */
TGameSprite *TGameSprite_Create(void)
{
  TGameSprite *class;

  class = malloc(sizeof(TGameSprite));
  if (class == NULL) {
    return(0);
  }
  class->Texture = NULL;
  class->TextureId = -1;
  class->DispSw = FALSE;

  return(class);
}


void TGameSprite_Destroy(TGameSprite *class)
{
  if (class) {
    free(class);
  }
}


/* ---------------------------------------- */
/* --- eNX`[̓o^                   */
/* ---------------------------------------- */
void TGameSprite_SetTextureDirect(TGameSprite *class,
				  int  texture_id,
				  SDL_Surface *bitmap)
{
  if (class == NULL) return;
  class->TextureId = texture_id;
  class->Texture = bitmap;
}
