/* ---------------------------------------------------------- */
/*  gamemain.h                                                */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* TCGS - BLOCK for PSP                                   */
/*                        Fumi2Kick                       */
/*                        1st Maintaner  rerofumi.        */
/*                                                        */
/*   gamemain.h                                           */
/*     Υե                                 */
/*                                                        */
/*--------------------------------------------------------*/

#ifndef GAMEMAIN_H
#define GAMEMAIN_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "SDL.h"
#include "grp_screen.h"
#include "block_game.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* --- 祹ơ */
#define  MAX_STAGE  10



/* --- ॹƥåפΥ٥ */
enum {
  StartUp,
  TitleInit,
  TitleMain,
  TitleAdvertise,
  GameInit,
  GameStageSet,
  GameMain,
  GameEndingInit,
  GameEnding,
  GameOver,
} MainStep;


/*-------------------------------*/
/* struct                        */
/*-------------------------------*/

typedef struct {
  int  titletimer;
  SDL_Surface  *tex;
  TGameScreen  *screen;
  int  step;

  /* ----- 鲼ϳƥѤΥȤƻȤäƤ */

  /* --- ֥åΤΥ󥹥 */
  TBlockGame *game;

  /* --- ߤΥơ */
  int  stage;

  /* --- ץ쥤䡼Υ */
  int  score;

  /* --- ϥ󥭥 */
  int  hi_score[5];

  /* --- طʥƥΥե̾ */
  char graphic_file[MAX_STAGE][256];

} TGameMain, *PTGameMain;

/* ---------------------------------------------- */
/* --- extern                                  -- */
/* ---------------------------------------------- */

TGameMain *TGameMain_Create(TGameScreen *mainscreen);
void TGameMain_Destroy(TGameMain *class);

int TGameMain_Poll(TGameMain *class,
		   int  counter);


#endif //GAMEMAIN_H
