/* ---------------------------------------------------------- */
/*  block_game.h                                              */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* TCGS - BLOCK for PSP                                   */
/*                        Fumi2Kick                       */
/*                        1st Maintaner  rerofumi.        */
/*                                                        */
/*   block_game.h                                         */
/*     ubÑQ[{                           */
/*                                                        */
/*--------------------------------------------------------*/

#ifndef BLOCK_GAME_H
#define BLOCK_GAME_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "SDL.h"
#include "grp_screen.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* --- Q[Xebṽx */
enum {
  STEP_STARTUP,
  STEP_PLAYING,
  STEP_CLEAR,
  STEP_GAMEOVER,
  STEP_DONE
} BlockGameStep;

/* --- Q[IR */
enum {
  REASON_PLAYING,
  REASON_CLEAR,
  REASON_GAMEOVER,
  REASON_ERROR
} ReturnReason;

/* --- Q[Jn̎ʐ */
#define MYBALLMAX  10

/* --- {[`ω臒l */
#define MYBALLVISUAL  3

/* --- ubN̍ő吔 */
#define BLOCKMAX  512

/* --- _\ACe̍ő吔 */
#define POINTMAX  128
#define POINT_SPEED_MAX  (1024*7)

/* --- t[TCY */
#define FRAME_W  480
#define FRAME_H  272

/* --- tB[hTCY */
#define FIELD_W  (480-8)
#define FIELD_H  (272-16)

/* --- ubN\Jnʒu(c̈ԏ) */
#define BLOCK_START_POS  (480-64-8-8)

/* --- ubNGȀcTCY */
#define BLOCK_W  8
#define BLOCK_H  24

#define BLOCK_SIZE_W 32
#define BLOCK_SIZE_H 16

/* --- phړXs[h(1024  1pixel) */
#define PADDLE_SPEED_LOW  (1024*3) 
#define PADDLE_SPEED_HIGH  (1024*6)

/* --- ph̒ */
#define PADDLE_SIZE_MAX 56
#define PADDKE_SIZE_MIN 16

/* --- {[̑傫 */
#define BALL_SIZE_W 12
#define BALL_SIZE_H 12

/* --- {[̉x */
#define BALL_ACCELERATOR 100

/* --- {[̍ő݊p */
#define BALL_ANGLE_MAX  60

/* --- Xe[W\oĂ鎞 */
#define DISP_STAGE_TIME  90

/*-------------------------------*/
/* SPTITE                        */
/*-------------------------------*/


#define SPRITE_GRAPHIC  0

#define SPRITE_SHADOW  100
#define SPRITE_BLOCK   300
#define SPRITE_POINT   600
#define SPRITE_BALL    880
#define SPRITE_PADDLE  896
#define SPRITE_FRAME   900
#define SPRITE_SCORE   910
#define SPRITE_INFO    935

/*-------------------------------*/
/* struct                        */
/*-------------------------------*/



/* --------------------------------------- */
/* --- {[ */
typedef struct {
  int  sw;
  int  w, h;
  int  x, y;
  int  speed;
  int  dir;
  int  type;
} SBlockBall, *PSBlockBall;

/* --------------------------------------- */
/* --- ph */
typedef struct {
  int  w;
  int  x, y;
  int  dir;
} SBlockPaddle, *PSBlockPaddle;

/* --------------------------------------- */
/* --- ubN */
typedef struct {
  int  sw;
  int  w, h;
  int  x, y;
  int  color;
  int  score;
} SBlockItem, *PSBlockItem;

/* --------------------------------------- */
/* --- _ */
typedef struct {
  int  sw;
  int  x, y;
  int  timer;
  int  speed;
  int  dir;
  int  score;
} SBlockPoint, *PSBlockPoint;



/* --------------------------------------- */
/* --- ubNNX */
typedef struct {

  /* --- isXebv */
  int  step;
  int  step_timer;

  /* --- Q[I̗R */
  int  reason;

  /* --- XRA */
  int  score;

  /* --- c{[̐ */
  int  ball_rest;
  int  ball_alive;

  /* --- {[̃Xs[h */
  int  ball_speed;
  int  ball_speed_max;

  /* --- ݂̃Xe[W */
  int  stage;

  /* --- LȃubN̐ */
  int  block_num;
  int  block_max;

  /* --- BGM 炵ĂtO*/
  int  bgm_playing;

  /* --- Xe[W */
  SBlockPaddle  pad;
  SBlockItem    block[BLOCKMAX];
  SBlockBall    ball[MYBALLMAX];
  SBlockPoint   point[POINTMAX];

  /* --- XN[NXւ̃ANZX|C^ */
  TGameScreen *screen;

} TBlockGame, *PTBlockGame;

/* ---------------------------------------------- */
/* --- extern                                  -- */
/* ---------------------------------------------- */

TBlockGame *TBlockGame_Create(TGameScreen *mainscreen);
void TBlockGame_Destroy(TBlockGame *class);

void TBlockGame_Init(TBlockGame *class);
void TBlockGame_StageStart(TBlockGame *class,
			   char *block_file,
			   char *graphic_file,
			   int speed,
			   int speed_max,
			   int stage_num);
void TBlockGame_SetScore(TBlockGame *class, int score);
int TBlockGame_GetScore(TBlockGame *class);
int TBlockGame_Poll(TBlockGame *class);


#endif //BLOCK_GAME_H
