/* ---------------------------------------------------------- */
/*  spriteitem.cpp                                          */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		XvCgǗNX
    @author		K.Kunikane (끗ӂ)
    @since		Feb.12.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "spriteitem.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
SpriteItem::SpriteItem()
{
  /* ---  */
  m_Working = false;
  m_Visible = false;
  m_PosX = 0.0;
  m_PosY = 0.0;
  m_SizeW = 0;
  m_SizeH = 0;
  m_Priority = 0;
  m_Blend = 1.0;
  m_Zoom = 1.0;
  m_TexU = 0;
  m_TexV = 0;
  m_TexW = 0;
  m_TexH = 0;
  m_RollZ = 0.0;
  m_RollX = 0.0;
  m_RollY = 0.0;
  m_TextureID = 0;
}


/**
 * fXgN^(n)
 */
SpriteItem::~SpriteItem()
{
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- SetLunaSprite() */
/**
 * ʂō쐬 LunaSprite nhnĂ炤
 * ̃NX͓nꂽnh̃v~eBuƂȂ
 *
 * @param sp_handle [in] LunaSpritenh
 * @return 
 *
 */
void SpriteItem::SetLunaSprite(LSPRITE sp_handle)
{
  m_LunaSprite = sp_handle;
}


/* ----------------------------------------- */
/* --- Display() */
/**
 * XvCg̕\
 * p[^ɏ]ăXvCgv~eBu LunaSprite 
 * o^
 *
 * @return Ȃ\ true s false
 *
 */
bool SpriteItem::Display()
{
  TGameSprite  *obj;

  if (m_Visible == true) {
    /* --- IuWFNg|C^󂯎 */
    obj = TGameScreen_GetSpriteSerial(m_LunaSprite);
    obj->Texture = TGameScreen_GetTexture(m_LunaSprite, m_TextureID);

    /* --- IuWFNg\ݒ */
    obj->DispSw = TRUE;
    obj->x = ((int)m_PosX/2) + 80;
    obj->y = ((int)m_PosY/2) + 16;
    if (m_PosCenter == true) {
      obj->x -= (m_SizeW / 2);
      obj->y -= (m_SizeH / 2);
    }
    obj->w = m_SizeW;
    obj->h = m_SizeH;
    obj->tx = m_TexU;
    obj->ty = m_TexV;
    obj->alpha = (int)(255.0 * m_Blend);
    obj->zoomx = m_Zoom;
    obj->zoomy = m_Zoom;
    obj->rotation_z = (360.0 * m_RollZ) / 65536.0;
  }

#if 0
  LUNARECT Dst, Src;
  D3DCOLOR  color;
  float  alpha;

  if (m_LunaSprite == INVALID_SPRITE) {
    return(false);
  }
  if ((m_Visible == false) || (m_Working == false)) {
    return(true);
  }

  /* --- \ʒu */
  if (m_PosCenter == true) {
    Dst.Set(m_PosX - (F(m_SizeW) / 2.0),
	    m_PosY - (F(m_SizeH) / 2.0),
	    F(m_SizeW),
	    F(m_SizeH));
  }
  else {
    Dst.Set(m_PosX, m_PosY, F(m_SizeW), F(m_SizeH));
  }
  /* --- texture UV */
  Src.Set(F(m_TexU), F(m_TexV), F(m_TexW), F(m_TexH));
  /* --- x̐ݒ */
  alpha = m_Blend;
  if (alpha > 1.0) {
    alpha = 1.0;
  }
  if (alpha < 0.0) {
    alpha = 0.0;
  }
  alpha *= 255;
  color = (D3DCOLOR)alpha;
  color <<= 24;
  color |= 0xffffff;
  /* --- v~eBuς */
  if ((m_RollX == 0.0) && (m_RollY == 0)) {
    if (m_RollZ == 0.0) {
      /* --- [e[g */
      LunaSprite::DrawSquare(m_LunaSprite,
			     &Dst,
			     F(m_Priority),
			     &Src,
			     color);
    }
    else {
      /* --- z[e[g */
      LunaSprite::DrawSquareRotate(m_LunaSprite,
				   &Dst,
				   F(m_Priority),
				   &Src,
				   color,
				   (unsigned long)m_RollZ);
    }
  }
  else {
    /* - O[e[g */
    LunaSprite::DrawSquareRotateXYZ(m_LunaSprite,
				    &Dst,
				    F(m_Priority),
				    &Src,
				    color,
				    (unsigned long)m_RollX,
				    (unsigned long)m_RollY,
				    (unsigned long)m_RollZ);
  }
#endif
  return(true);
}



/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

