/* ---------------------------------------------------------- */
/*  shootingobject.cpp                                        */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		蔻tXvCg
    @author		K.Kunikane (끗ӂ)
    @since		Feb.14.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "shootingobject.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
ShootingObject::ShootingObject()
{
  /* ---  */
  m_GrazeEnable = false;
  m_HitEnable = false;
  m_HitR = 0.0;
  m_HitPow = 0.0;
  m_GrazeR = 0.0;
  m_GrazePow = 0.0;
}


/**
 * fXgN^(n)
 */
ShootingObject::~ShootingObject()
{
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- SetHitSize() */
/**
 * ̃IuWFNg̓蔻蔼aZbg
 *
 * @param r [in] IuWFNg蔻̔a
 * @return 
 *
 */
void ShootingObject::SetHitSize(float r)
{
  m_HitR = r;
  m_HitPow = r * r;
}


/* ----------------------------------------- */
/* --- SetGrazeSize() */
/**
 * ̃IuWFNĝ蔻蔼aZbg
 *
 * @param r [in] IuWFNg蔻̔a
 * @return 
 *
 */
void ShootingObject::SetGrazeSize(float r)
{
  m_GrazeR = r;
  m_GrazePow = r * r;
}

/* ----------------------------------------- */
/* --- CheckCollision() */
/**
 * IuWFNgm̓蔻
 * ܂ɋ`Ŕʂ߂Ȃ~̏Փ˔
 *
 * @return Ȃ\ true s false
 *
 */
bool ShootingObject::CheckCollision(ShootingObject* obj)
{
  float  dx, dy, dr;
  bool quick;

  /* --- LȃIuWFNgłȂI */
  if (m_HitEnable == false) {
    return(false);
  }
  if (obj->m_HitEnable == false) {
    return(false);
  }
  quick = true;
  dr = m_HitR + obj->m_HitR;
  dx = m_PosX - obj->m_PosX;
  dy = m_PosY - obj->m_PosY;
  /* --- ȈՔ肻1 */
  if (dx < 0) {
    dx *= (-1.0);
    if (dx > dr) {
      quick = false;
    }
  }
  else {
    if (dx > dr) {
      quick = false;
    }
  }
  /* - x ̊J傫AƏI */
  if (quick == false) {
    return(false);
  }
  /* --- ȈՔ肻2 */
  if (dy < 0) {
    dy *= (-1.0);
    if (dy > dr) {
      quick = false;
    }
  }
  else {
    if (dy > dr) {
      quick = false;
    }
  }
  /* - y ̊J傫AƏI */
  if (quick == false) {
    return(false);
  }
  /* --- ʂɉ~̋Ŕ */
  dx *= dx;
  dy *= dy;
  dr *= dr;
  dx += dy;
  if (dr < dx) {
    return(false);
  }

  return(true);
}


/* ----------------------------------------- */
/* --- CheckGraze() */
/**
 * IuWFNĝ蔻
 * ̓苗Ƃ̂苗Ŕ
 *
 * @return Ȃ\ true s false
 *
 */
bool ShootingObject::CheckGraze(ShootingObject* obj)
{
  float  dx, dy, dr;
  bool quick;

  /* --- LȃIuWFNgłȂI */
  if (m_GrazeEnable == false) {
    return(false);
  }
  if (obj->m_GrazeEnable == false) {
    return(false);
  }

  quick = true;
  dr = m_GrazeR + obj->m_GrazeR;
  dx = m_PosX - obj->m_PosX;
  dy = m_PosY - obj->m_PosY;
  /* --- ȈՔ肻1 */
  if (dx < 0) {
    dx *= (-1.0);
    if (dx > dr) {
      quick = false;
    }
  }
  else {
    if (dx > dr) {
      quick = false;
    }
  }
  /* - x ̊J傫AƏI */
  if (quick == false) {
    return(false);
  }
  /* --- ȈՔ肻2 */
  if (dy < 0) {
    dy *= (-1.0);
    if (dy > dr) {
      quick = false;
    }
  }
  else {
    if (dy > dr) {
      quick = false;
    }
  }
  /* - y ̊J傫AƏI */
  if (quick == false) {
    return(false);
  }
  /* --- ʂɉ~̋Ŕ */
  dx *= dx;
  dy *= dy;
  dr *= dr;
  dx += dy;
  if (dr < dx) {
    return(false);
  }

  return(true);
}

/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

