/* ---------------------------------------------------------- */
/*  myshotmanage.cpp                                          */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		@̒eǗNX
    @author		K.Kunikane (끗ӂ)
    @since		Feb.15.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "myshotmanage.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
MyShotManage::MyShotManage()
{
  /* ---  */
  m_Execute = false;
  m_State = 0;
  m_Timer = 0;
}


/**
 * fXgN^(n)
 */
MyShotManage::~MyShotManage()
{
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- Tick() */
/**
 * t[Ƃ̍
 *
 * @return true ȂړAfalse Ȃ~
 *
 */
bool MyShotManage::Tick()
{
  bool  result;

  if (m_Timer == 0) {
    /* --- X[p[NX Tick Ăяo */
    result = BulletBase::Tick();
    m_Execute = result;
    if (result == false) {
      m_Working = false;
      m_Visible = false;
      m_HitEnable = false;
    }
  }
  else {
    m_Timer -= 1;
    if (m_Timer <= 0) {
      m_Execute = false;
      m_Working = false;
      m_Visible = false;
      m_HitEnable = false;
      result = false;
    }
    else {
      result = true;
    }
  }

  return(result);
}

/* ----------------------------------------- */
/* --- Shoot() */
/**
 * ˃NGXg
 *
 * @return true Ȃ甭ˏAfalse Ȃ珈
 *
 */
bool MyShotManage::Shoot(MyShipManage* ship)
{
  bool  alive;

  alive = false;

  if (m_Execute == false) {
    /* --- @eIuWFNg̐ */
    /* - IuWFNg̏ */
    m_SizeW = 8;
    m_SizeH = 16;
    m_Priority = BS_DEPTH_MYSHOT;
    m_Blend = 1.0;
    m_Zoom = 1.0;
    m_TexU = 112 + (8 * SIENSIDE);
    m_TexV = 0;
    m_TexW = 8;
    m_TexH = 16;
    m_RollZ = 0.0;
    m_PosCenter = true;
    m_Working = true;
    m_Visible = true;
    /* - 蔻 */
    SetHitSize(4.0);
    SetGrazeSize(4.0);
    m_HitEnable = true;
    /* - ʒu */
    m_PosX = ship->m_PosX;
    m_PosY = ship->m_PosY - 4;
    /* - ړx */
    m_Direction = (65536.0 / 4) * 3;
    m_DirectionAdd = 0.0;
    m_Speed = 1.0;
    m_SpeedR = 0.0;
    m_Accelerator = 0.2;
    m_AcceleratorR = 0.0;
    m_Limit = 20.0;
    m_LimitR = 0.0;
    m_AddRoll = 0.0;
    m_LifeTime = 600;
    m_ListPrev = NULL;
    m_ListNext = NULL;
    /* - s */
    m_Execute = true;
    alive = true;
  }

  /* --- ܂ */
  return(alive);
}


/* ----------------------------------------- */
/* --- CanShoot() */
/**
 * e𔭎˂鎖\ǂ̊mF
 *
 * @return true Ȃ甭ˉ\Afalse Ȃs
 *
 */
bool MyShotManage::CanShoot()
{
  return(!m_Execute);
}

/* ----------------------------------------- */
/* --- SetState() */
/**
 * eɊւԒl̃Zbg
 * 芸gpǂAIɉ邩Ȃ̂
 *
 * @param stat [in] ZbgԒl
 * @return 
 *
 */
void MyShotManage::SetState(int stat)
{
  m_State = stat;
}

/* ----------------------------------------- */
/* --- SetState() */
/**
 * eɊւԒlԂ
 * 芸gpǂAIɉ邩Ȃ̂
 *
 * @return Ԓl
 *
 */
int MyShotManage::GetState()
{
  return(m_State);
}

/* ----------------------------------------- */
/* --- SetWait() */
/**
 * Gɓサ΂炭̃EFCg܂߂̐ݒ
 *
 * @param time [in] t[YĂ
 * @return Ԓl
 *
 */
void  MyShotManage::SetWait(int time)
{
  m_Timer = time;
  m_Visible = false;
}


/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

