/* ---------------------------------------------------------- */
/*  grp_sprite.h                                              */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   grp_sprite.h                                         */
/*     ץ饤ȴ¤                               */
/*                                                        */
/*--------------------------------------------------------*/

#ifndef GRP_SPRITE_H
#define GRP_SPRITE_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "SDL.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/*-------------------------------*/
/* struct                        */
/*-------------------------------*/

typedef struct {
  int  TextureId;
  /* - public */
  int  DispSw;
  int  x, y;
  int  w, h;
  int  tx, ty;
  float  zoomx, zoomy;
  float  rotation_z;
  unsigned char  alpha;
  SDL_Surface  *Texture;
} TGameSprite, *PTGameSprite;

/* ---------------------------------------------- */
/* --- extern                                  -- */
/* ---------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif	//__cplusplus

TGameSprite *TGameSprite_Create(void);
void TGameSprite_Destroy(TGameSprite *pclass);

void TGameSprite_SetTextureDirect(TGameSprite *pclass,
				  int  texture_id,
				  SDL_Surface *bitmap);

#ifdef __cplusplus
}
#endif  //__cplusplus

#endif //GRP_SPRITE_H
