/* ---------------------------------------------------------- */
/*  grp_screen.h                                              */
/* ---------------------------------------------------------- */

/*--------------------------------------------------------*/
/*                                                        */
/* SDL puzzle project - for COMIKET62                     */
/*                        Fumi2Kick/LiMo/omamori-2002     */
/*                        1st Maintaner  Rerorero@fumi.   */
/*                                                        */
/*   debug.pp                                             */
/*     ǥХåѥå롼                         */
/*                                                        */
/*--------------------------------------------------------*/
/* -- $Id: debug.pp,v 1.3 2002/07/11 17:21:47 rero2 Exp $ */


/*------------------------------------------------------------- */
/** @file
    @brief		ɽ
    @author		K.Kunikane (rerofumi)
    @since		Jul.27.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2002,2005 rerofumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/


#ifndef GRP_SCREEN_H
#define GRP_SCREEN_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "SDL.h"

#include "grp_texture.h"
#include "grp_sprite.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/* --- 祹ץ饤ȿ */
#define  SPRITEMAX  1024


#if (SDL_BYTEORDER == SDL_BIG_ENDIAN)
 #define DRmask 0xff000000
 #define DGmask 0x00ff0000
 #define DBmask 0x0000ff00
 #define DAmask 0x000000ff
#else
 #define DRmask 0x000000ff
 #define DGmask 0x0000ff00
 #define DBmask 0x00ff0000
 #define DAmask 0xff000000
#endif


/*-------------------------------*/
/* struct                        */
/*-------------------------------*/

typedef struct {
  SDL_Surface *Screen;
  TGameTexture *Texture;
  TGameSprite  *Sprites[SPRITEMAX];
  int Width;
  int Height;
  int Depth;
  /// ץ饤༡ɤ߽Фѥ󥿡
  int SpriteSerial;
  /// 西åȤˤʤäƤ GU ե졼ХåեΥݥ
  unsigned char *current_buffer_ptr;
  /// PSPǤGUѥåȥꥢ
  unsigned int  *packet;
} TGameScreen, *PTGameScreen;


/* ---------------------------------------------- */
/* --- extern                                  -- */
/* ---------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif	//__cplusplus

TGameScreen *TGameScreen_Create(int width, int height, int depth);
void TGameScreen_Destroy(TGameScreen *pclass);
void TGameScreen_SetWMName(TGameScreen *pclass, char *name);
void TGameScreen_DispScreen(TGameScreen *pclass);
void TGameScreen_RefreshScreen(TGameScreen *pclass);

TGameSprite *TGameScreen_GetSprite(TGameScreen *pclass, int id);
TGameSprite *TGameScreen_GetSpriteSerial(TGameScreen *pclass);
void TGameScreen_ClearSprite(TGameScreen *pclass);
SDL_Surface *TGameScreen_GetTexture(TGameScreen *pclass, int id);
void TGameScreen_LoadTexture(TGameScreen *pclass, int num, char *filename);
void TGameScreen_LoadTexturePure(TGameScreen *pclass, int num, char *filename);

#ifdef __cplusplus
}
#endif  //__cplusplus


#endif //GRP_SCREEN_H






