/* ---------------------------------------------------------- */
/*  GameDirector.h                                            */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		Q[{̂ƐisǗ
    @author		K.Kunikane (끗ӂ)
    @since		Feb.12.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

#ifndef GAMEDIRECTOR_H
#define GAMEDIRECTOR_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "lunavader.h"
#include "basicsystem.h"
#include "panelmanage.h"
#include "myshipmanage.h"
#include "myshotmanage.h"
#include "convoymanage.h"
#include "bulletmanage.h"
#include "bonusshipmanage.h"
#include "backgroundmanage.h"
#include "titlemanage.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/*-------------------------------*/
/* struct                        */
/*-------------------------------*/

/*-------------------------------*/
/* class                         */
/*-------------------------------*/

/**
 * @brief Q[isǗNX
 *        Q[̐isǗIuWFNgǗsA
 *        ۂ̃Q[vCł悤ɐisgݗĂ܂
 *
 * @todo -
 * @bug -
 */
class GameDirector
{
  /* ----------------------------------- */
  /* --- RXgN^EfXgN^ */
 public:
  GameDirector();
  virtual  ~GameDirector();

  /* ----------------------------------- */
  /* --- pubNo */
 public:
  //! Q[XRA
  long  m_Score;
  //! Q[nCXRA
  long  m_HighScore;
  //! Xe[W
  int  m_Stage;

  /* ----------------------------------- */
  /* --- vCx[go */
 private:
  //! Q[̐isԂXebvJE^
  int m_GameStep;
  //! 1Q[ɂ邩|Cg̃XRA
  int m_Graze;
  //! Q[isɂEFCgKvȎ̑ҋ@JE^
  int m_Wait;
  //! Q[is̃|[YԂtO
  bool m_Pause;
  /* -- ֘ANX */
  //! Luna ANZXpCX^X̕ێ
  BasicSystem*  m_SystemMan;
  //! XRApl\CX^X
  PanelManage*  m_PanelMan;
  //! @ǗCX^X̕ێ
  MyShipManage*  m_MyShipMan;
  //! @˒eǗCX^X̕ێ
  MyShotManage*  m_MyShotMan;
  //! GQ̊ǗCX^X̕ێ
  ConvoyManage*  m_EnemyMan;
  //! G̒eGtFNg̊ǗCX^X̕ێ
  BulletManage*  m_BulletMan;
  //! UFOǗCX^X̕ێ
  BonusShipManage*  m_BonusMan;
  //! wiǗCX^X̕ێ
  BackGroundManage*  m_BgMan;
  //! wiǗCX^X̕ێ
  TitleManage*  m_TitleMan;

  //! GsJE^
  int m_EnemyWalkCounter;
  //! [J^CJE^[
  int m_Counter;
  //! {[iXo^C~O
  int m_BonusTimer;

  /* ----------------------------------- */
  /* --- pubN\bh */
 public:
  void SetBasicSystem(BasicSystem* sysclass);
  void Init();
  bool Tick();
  void Pause(bool pause_sw);

  /* ----------------------------------- */
  /* --- vCx[g\bh */
 private:
  void game_init();
  void stage_init();
  bool game_execute();
  bool game_over();

};


#endif

