/* ---------------------------------------------------------- */
/*  gamedirector.cpp                                          */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		Q[{̂ƐisǗ
    @author		K.Kunikane (끗ӂ)
    @since		Feb.12.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "gamedirector.h"
#include "lunamath.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

const  int  enemy_walk_sound[22] = {
  0, 1, 2, 3, 2, 1,
  0, 1, 2, 3, 2, 1,
  0, 1, 2, 3, 2, 1,
  4, 5, 4, 6,
};

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
GameDirector::GameDirector()
{
  /* ---  */
  m_Score = 0;
  m_HighScore = 0;
  m_Graze = 0;
  m_GameStep = 0;
  m_Wait = 0;
  m_Pause = false;
  m_EnemyWalkCounter = 0;
  /* --- eNX */
  m_SystemMan = NULL;
  m_PanelMan = NULL;
  m_MyShipMan = NULL;
  m_MyShotMan = NULL;
  m_EnemyMan = NULL;
  m_BulletMan = NULL;
  m_BonusMan = NULL;
  m_BgMan = NULL;
  m_TitleMan = NULL;
  /* --- [JJE^[ */
  m_Counter = 0;
}


/**
 * fXgN^(n)
 */
GameDirector::~GameDirector()
{
  if (m_PanelMan) {
    delete m_PanelMan;
  }
  if (m_MyShipMan) {
    delete m_MyShipMan;
  }
  if (m_MyShotMan) {
    delete m_MyShotMan;
  }
  if (m_BulletMan) {
    delete m_BulletMan;
  }
  if (m_BonusMan) {
    delete m_BonusMan;
  }
  if (m_BgMan) {
    delete m_BgMan;
  }
  if (m_TitleMan) {
    delete m_TitleMan;
  }
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- SetBasicSystem() */
/**
 * ʂō쐬 BasicSystem CX^XnĂ炤
 * XvCgȊO Luna ANZX͓nĂCX^X
 * ɂĂقƂǂBAۉ鎖ɂȂB
 * O SpriteItem ɂ 1XvCg̕`敔B
 *
 * @param sysclass [in] BasicSystem̃CX^X
 * @return 
 *
 */
void GameDirector::SetBasicSystem(BasicSystem* sysclass)
{
  m_SystemMan = sysclass;

}


/* ----------------------------------------- */
/* --- Init() */
/**
 * Q[̏ԂB
 * RXgN^Ƃقړ邪A
 * ʂŃNXI[v܂܂̏ԂŐVKQ[
 * JnꍇɗLB
 *
 * @return 
 *
 */
void GameDirector::Init()
{
  BulletMaker  *obj;

  /* ---  */
  m_Score = 0;
  m_HighScore = 0;
  m_Graze = 0;
  m_GameStep = 0;
  m_Wait = 0;
  m_Pause = false;

  /* --- CX^X̐ */
  m_PanelMan = new PanelManage;
  m_MyShipMan = new MyShipManage;
  m_MyShotMan = new MyShotManage;
  m_EnemyMan = new ConvoyManage;
  m_BulletMan = new BulletManage;
  m_BonusMan = new BonusShipManage;
  m_BgMan = new BackGroundManage;
  m_TitleMan = new TitleManage;

  /* --- XvCgnh̒` */
  if (m_SystemMan) {
    m_PanelMan->SetLunaSprite(m_SystemMan->screen);
  }
  if (m_SystemMan) {
    m_MyShipMan->SetLunaSprite(m_SystemMan->screen);
  }
  if (m_SystemMan) {
    m_MyShotMan->SetLunaSprite(m_SystemMan->screen);
  }
  if (m_EnemyMan) {
    m_EnemyMan->SetLunaSprite(m_SystemMan->screen);
  }
  if (m_BonusMan) {
    m_BonusMan->SetLunaSprite(m_SystemMan->screen);
  }
  if (m_BgMan) {
    m_BgMan->SetLunaSprite(m_SystemMan->screen);
  }
  if (m_TitleMan) {
    m_TitleMan->SetLunaSprite(m_SystemMan->screen);
  }

  /* --- GǗpeCX^X */
  obj = new BulletMaker;
  obj->SetMyShip(m_MyShipMan);
  obj->SetLunaSprite(m_SystemMan->screen);
  obj->SetManager(m_BulletMan);
  m_EnemyMan->SetBulletMaker(obj);

  /* --- NX̏ */
  game_init();

  /* --- Xe[W̏ */
  stage_init();

}


/* ----------------------------------------- */
/* --- Tick() */
/**
 * Q[isǗ암B
 * t[ƂɃR[邱ƁB
 *
 * @return trueŃQ[isAfalse ŃQ[I
 *
 */
bool GameDirector::Tick()
{
  unsigned char  line[128];

  m_Counter += 1;
#ifdef DEBUG
  /* --- p clock \ */
  sprintf((char*)line, "Clock: %d", m_Counter);
  m_SystemMan->AddDebugMessage(line);
#endif


  switch(m_GameStep) {
  case 0:
    m_TitleMan->Init();
    m_GameStep = 1;
    break;

  case 1:
    if (m_TitleMan->Tick(m_SystemMan->GetKeyInputTriger()) == false) {
      m_GameStep = 2;
    }
    if (m_TitleMan->Start()) {
      m_SystemMan->PlaySoundEffect(8);
    }
    m_TitleMan->Display();
    break;
 
  case 2:
    game_init();
    stage_init();
    /* rand seed initialize */
    LunaMath::Initialize(m_Counter);
    m_GameStep = 3;
    break;

  case 3:
    /* --- Q[{ */
    if (game_execute() == false) {
      m_Wait = 90;
      m_GameStep = 4;
    }
    break;

  case 4:
    /* --- Q[I[o[ */
    if (game_over() == false) {
      m_GameStep = 0;
    }
    break;
  }

  return(true);
}


/* ----------------------------------------- */
/* --- Pause() */
/**
 * Q[is̈ꎞ~ԂZbgB
 * ꎞ~͖t[ Tick() ~߂ȂꍇƂ
 * ~͂ʂ͕\Ăė~ꍇɗpB
 *
 * @param pause_sw [in] true ňꎞ~Afalse Œʏis
 * @return 
 *
 */
void GameDirector::Pause(bool pause_sw)
{
}


/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

/* --- game_init() */
/**
 * Q[is̏B
 * RXgN^ Init() ̎́B
 *
 * @return 
 *
 */
void GameDirector::game_init()
{
  m_MyShipMan->Init();
  m_BonusMan->SetCharactor(SIENSIDE);
  m_Stage = 1;
  m_Score = 0;
  m_Graze = 0;
  m_PanelMan->SetHighScore(m_HighScore);
  m_PanelMan->SetGameOver(false);
  m_BgMan->Init();
  m_BgMan->SetBlend(0.0);
}

/* --- stage_init() */
/**
 * 1Xe[WI(Jn)̏ƁB
 * ɓǦQ̏ƐB
 *
 * @return 
 *
 */
void GameDirector::stage_init()
{
  m_EnemyMan->Init(m_Stage);
  m_BonusTimer = 1200 + LunaMath::Rand(0, 1200);
  m_PanelMan->SetStage(m_Stage);
  m_BulletMan->Init();
}


/* --- game_over() */
/**
 * Q[I[o[̕\ƐisȂǁB
 *
 * @return true ōƒAfalse ōƏI
 *
 */
bool GameDirector::game_over()
{
  bool result;
  result = false;

  /* --- Q[I[o[̕\ */
  m_PanelMan->SetGameOver(true);
  m_PanelMan->Tick();

  /* --- XvCg\ */
  m_BgMan->Display();
  m_MyShotMan->Display();
  m_MyShipMan->Display();
  m_BonusMan->Display();
  m_BulletMan->Display();
  m_PanelMan->Display();

  m_Wait -= 1;
  if (m_Wait == 0) {
    result = false;
    /* -- nCXRA̍XVȂ */
    if (m_Score > m_HighScore) {
      m_HighScore = m_Score;
    }
  }
  else {
    result = true;
  }

  return(result);
}

/* --- game_execute() */
/**
 * Q[Q[炵߂B
 * eIuWFNg̑ƘAgiQ[{̕B
 *
 * @return true ōƒAfalse ŃQ[I
 *
 */
bool GameDirector::game_execute()
{
  bool  result;
  int  score, graze;
  int  num;
  float bgblend;

  result = true;

  /* --- wi */
  if (m_EnemyMan->GetRestEnemy() == (CV_COLUMN * CV_ROW)) {
    bgblend = 0.0001;
  }
  else {
    bgblend = (float)((CV_COLUMN * CV_ROW) -
		      m_EnemyMan->GetRestEnemy());
    bgblend = bgblend / (float)(CV_COLUMN * CV_ROW);
  }
  m_BgMan->SetBlend(bgblend);
  m_BgMan->Tick();
  m_BgMan->Display();

  /* --- XRApl */
  m_PanelMan->SetScore(m_Score);
  m_PanelMan->SetGraze(m_Graze);
  m_PanelMan->Tick();

  /* --- @ړ */
  m_MyShipMan->Tick(m_SystemMan->GetKeyInput(),
		    m_SystemMan->GetKeyInputTriger());

  /* --- Vbg */
  if (m_SystemMan->GetKeyInputTriger() & BS_INPUT_BUTTON1) {
    if (m_MyShotMan->Shoot(m_MyShipMan)) {
      /* - Vbg */
      m_SystemMan->PlaySoundEffect(9);
    }
  }
  m_MyShotMan->Tick();

  /* --- Gړ */
  if (m_EnemyMan->Tick()) {
    /* - Gs */
    m_SystemMan->PlaySoundEffect(enemy_walk_sound[m_EnemyWalkCounter]+1);
    m_EnemyWalkCounter = (m_EnemyWalkCounter + 1) % 22;
  }

  /* --- @VbgƓGƂ̔ */
  score = m_EnemyMan->CheckHit(m_MyShotMan);
  if (score > 0) {
    /* -- Gɓ */
    m_SystemMan->PlaySoundEffect(11);
    m_Score += score;
  }

  /* --- eړǗ */
  m_BulletMan->Tick();
  if (m_BulletMan->CheckHit(m_MyShipMan)) {
    /* - G̒eɓ */
    m_SystemMan->StopMusic();
    m_SystemMan->PlaySoundEffect(10);
    result = false;
  }
  graze = m_BulletMan->GetGraze();
  if (graze > 0) {
    /* - eɂ */
    m_SystemMan->PlaySoundEffect(13);
    m_Graze += graze;
    m_Score += graze * 100;
  }

  /* --- {[iXDǗ */
  /* ړƓ蔻 */
  if (m_BonusMan->GetState()) {
    if (m_BonusMan->Tick() == false) {
      m_BonusTimer = 600 + LunaMath::Rand(0, 600);
      m_SystemMan->StopMusic();
    }
    if (m_BonusMan->CheckHit(m_MyShotMan)) {
      m_Score += m_BonusMan->GetScore();
      /* -- Hit GtFNg */
      {
	BulletMaker maker;
	maker.SetLunaSprite(m_SystemMan->screen);
	maker.SetManager(m_BulletMan);
	maker.RequestEffect(2,
			    m_BonusMan->m_PosX,
			    m_BonusMan->m_PosY);
      }
      /* -- Gɓ */
      m_SystemMan->StopMusic();
      m_SystemMan->PlaySoundEffect(12);
      m_BonusTimer = 600 + LunaMath::Rand(0, 600);
    }
  }
  else {
    if (m_BonusTimer == 0) {
      m_BonusMan->SetScore(5000 *  LunaMath::Rand(1, 6));
      m_BonusMan->Start();
      m_SystemMan->PlayMusic(1);
    }
    else {
      m_BonusTimer -= 1;
    }
  }


  /* - GȂȂ玟̖ʂ */
  if (m_EnemyMan->GetRestEnemy() == 0) {
    m_Score += m_BulletMan->DisableAllBullet() * 10;
    m_Stage += 1;
    stage_init();
  }

  /* --- XvCg\ */
  m_MyShotMan->Display();
  m_MyShipMan->Display();
  m_BonusMan->Display();
  num = m_BulletMan->Display();
  m_PanelMan->Display();

#ifdef DEBUG
  /* --- eIuWFNg̐ */
  {
    unsigned char *line;
    line = new unsigned char[127];
    sprintf((char*)line, "Bullet Num: %d", num);
    m_SystemMan->AddDebugMessage(line);
    sprintf((char*)line, "Bonus Ship Timer: %d", m_BonusTimer);
    m_SystemMan->AddDebugMessage(line);
    delete line;
  }
#endif

  return(result);
}

