/* ---------------------------------------------------------- */
/*  convoymanage.cpp                                          */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		GQ̂̈ړƊǗsNX
    @author		K.Kunikane (끗ӂ)
    @since		Feb.16.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "convoymanage.h"
#include "myshotmanage.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
ConvoyManage::ConvoyManage()
{
  /* ---  */
  m_Convoy = new EnemyObject[CV_COLUMN * CV_ROW];
  m_BulletMaker = NULL;
}


/**
 * fXgN^(n)
 */
ConvoyManage::~ConvoyManage()
{
  delete  m_Convoy;
  delete  m_BulletMaker;
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- Init() */
/**
 * Q̂̏Az
 *
 * @return 
 *
 */
void ConvoyManage::Init(int level)
{
  /* --- o[ */
  m_Level = level;
  m_WalkStat = ENEMY_WALK_SEQ_RIGHT;
  m_WalkMember = 0;
  m_WalkPattern = 0;
  m_Wait = 0;
  m_HitWait = 0;
  m_Timer = 0;
  /* --- R{C */
  set_enemy();
  /* --- eɂxݒ */
  m_BulletMaker->SetLevel(level);
}


/* ----------------------------------------- */
/* --- Tick() */
/**
 * Q̂̈ړAʏ폈
 *
 * @return false ŒʏAtrue ŕs炷
 *
 */
bool  ConvoyManage::Tick()
{
  bool  walk;
  float  min, max;
  int  i, j;

  /* --- eqbgɂEFCg */
  for(i=0; i<CV_ROW; i++) {
    for(j=0; j<CV_COLUMN; j++) {
      m_Convoy[j+(i*CV_COLUMN)].Tick();
    }
  }
  if (m_HitWait > 0) {
    m_HitWait -= 1;
    if (m_HitWait == 0) {
      /* eɓĂG */
      for(i=0; i<CV_ROW; i++) {
	for(j=0; j<CV_COLUMN; j++) {
	  if (m_Convoy[j+(i*CV_COLUMN)].m_IsHit == true) {
	    m_Convoy[j+(i*CV_COLUMN)].m_Visible = false;
	    m_Convoy[j+(i*CV_COLUMN)].m_Working = false;
	    m_Convoy[j+(i*CV_COLUMN)].m_HitEnable = false;
	    m_Convoy[j+(i*CV_COLUMN)].m_IsHit = false;
	  }
	}
      }
    }
    /* --- Q̃IuWFNg\ */
    for(i=0; i<CV_ROW; i++) {
      for(j=0; j<CV_COLUMN; j++) {
	m_Convoy[j+(i*CV_COLUMN)].Display();
      }
    }
    /* I */
    return(false);
  }

  /* --- Q̃IuWFNgǗ */
  walk = false;
  i = m_WalkMember;
  while(i < (CV_COLUMN * CV_ROW)) {
    if (m_Convoy[i].m_Working == true) {
      /* -  */
      switch(m_WalkStat) {
      case ENEMY_WALK_SEQ_RIGHT:
	m_Convoy[i].m_PosX += 6.0;
	m_Convoy[i].SetWalkPattern(m_WalkPattern);
	break;

      case ENEMY_WALK_SEQ_DOWN1:
	m_Convoy[i].m_PosY += 8.0;
	m_Convoy[i].SetWalkPattern(m_WalkPattern);
	break;

      case ENEMY_WALK_SEQ_LEFT:
	m_Convoy[i].m_PosX -= 6.0;
	m_Convoy[i].SetWalkPattern(m_WalkPattern);
	break;

      case ENEMY_WALK_SEQ_DOWN2:
	m_Convoy[i].m_PosY += 8.0;
	m_Convoy[i].SetWalkPattern(m_WalkPattern);
	break;
      }
      break;
    }
    i++;
  }
  if (i == (CV_COLUMN * CV_ROW)) {
    /* - ꏄ */
    walk = true;
    m_WalkPattern ^= 1;
    m_WalkMember = 0;
    /* [ */
    min = max = (GAMEFIELD_W / 2);
    for(i=0; i<CV_ROW; i++) {
      for(j=0; j<CV_COLUMN; j++) {
	if (m_Convoy[j+(i*CV_COLUMN)].m_Working == true) {
	  if (m_Convoy[j+(i*CV_COLUMN)].m_PosX <= min) {
	    min = m_Convoy[j+(i*CV_COLUMN)].m_PosX;
	  }
	  if (m_Convoy[j+(i*CV_COLUMN)].m_PosX >= max) {
	    max = m_Convoy[j+(i*CV_COLUMN)].m_PosX;
	  }
	}
      }
    }
    /* Xebvֈڂ邩ǂf */
    switch(m_WalkStat) {
    case ENEMY_WALK_SEQ_RIGHT:
      if (max > 428) {
	m_WalkStat += 1;
      }
      break;

    case ENEMY_WALK_SEQ_LEFT:
      if (min < 20) {
	m_WalkStat += 1;
      }
      break;
	
    case ENEMY_WALK_SEQ_DOWN1:
	m_WalkStat += 1;
      break;

    case ENEMY_WALK_SEQ_DOWN2:
	m_WalkStat = ENEMY_WALK_SEQ_RIGHT;
      break;
    }
  }
  else {
    m_WalkMember = (i + 1);
  }

  /* --- Q̃IuWFNg\ */
  for(i=0; i<CV_ROW; i++) {
    for(j=0; j<CV_COLUMN; j++) {
      m_Convoy[j+(i*CV_COLUMN)].Display();
    }
  }
  

  /* --- Ũ^C~O */
  m_Timer += 1;
  if (m_Level < 2) {
    if ((m_Timer % 100) == 0) {
      attack_enemy();
    }
  }
  else if (m_Level < 4) {
    if ((m_Timer % 80) == 0) {
      attack_enemy();
    }
  }
  else {
    if ((m_Timer % 60) == 0) {
      attack_enemy();
    }
  }


  return(walk);
}


/* ----------------------------------------- */
/* --- SetBulletMaker() */
/**
 * eGtFNg𐶐CX^X̎󂯎
 *
 * @return 
 *
 */
void  ConvoyManage::SetBulletMaker(BulletMaker *bulletmaker)
{
  m_BulletMaker = bulletmaker;
}


/* ----------------------------------------- */
/* --- IsInvade() */
/**
 * NɂQ[I[o[
 *
 * @return false ŒʏAtrue ŃQ[I[o[
 *
 */
bool  ConvoyManage::IsInvade()
{
  bool result;
  float  max;
  int i, j;

  result = false;
  /* --- ŉ[ */
  max = 0;
  for(i=0; i<CV_ROW; i++) {
    for(j=0; j<CV_COLUMN; j++) {
      if (m_Convoy[j+(i*CV_COLUMN)].m_Working == true) {
	if (m_Convoy[j+(i*CV_COLUMN)].m_PosY >= max) {
	  max = m_Convoy[j+(i*CV_COLUMN)].m_PosY;
	}
      }
    }
  }
  /* ---  */
  if (max >= 440) {
    result = true;
  }
  
  return(result);
}

/* ----------------------------------------- */
/* --- GetRestEnemy() */
/**
 * G̎c萔
 *
 * @return ݂̓G
 *
 */
int  ConvoyManage::GetRestEnemy()
{
  int  i, j, n;

  n = 0;
  for(i=0; i<CV_ROW; i++) {
    for(j=0; j<CV_COLUMN; j++) {
      if (m_Convoy[j+(i*CV_COLUMN)].m_Working == true) {
	n += 1;
      }
    }
  }

  return(n);
}

/* ----------------------------------------- */
/* --- CheckHit() */
/**
 * @eɑ΂G̓蔻
 *
 * @return qbgƂ̓GL_
 *
 */
int  ConvoyManage::CheckHit(MyShotManage* shot)
{
  int  i, j, score;
  
  score = 0;
  for(i=0; i<CV_ROW; i++) {
    for(j=0; j<CV_COLUMN; j++) {
      if (m_Convoy[j+(i*CV_COLUMN)].m_Working == true) {
	if (m_Convoy[j+(i*CV_COLUMN)].CheckCollision(shot)) {
	  /* ---  */
	  m_Convoy[j+(i*CV_COLUMN)].Hit();
	  m_HitWait = ENEMYHIT_WAIT;
	  score = m_Convoy[j+(i*CV_COLUMN)].GetScore();
	  shot->m_Working = false;
	  shot->m_Visible = false;
	  shot->m_HitEnable = false;
	  shot->SetWait(ENEMYHIT_WAIT);
	  /* - GtFNg */
	  m_BulletMaker->RequestEffect(1,
				       m_Convoy[j+(i*CV_COLUMN)].m_PosX,
				       m_Convoy[j+(i*CV_COLUMN)].m_PosY);
	}
      }
    }
  }
  return(score);
}

/* ----------------------------------------- */
/* --- SetLunaSprite() */
/**
 * XvCgobt@̎󂯎
 *
 * @param handle [in] XvCgobt@
 * @return 
 *
 */
void  ConvoyManage::SetLunaSprite(LSPRITE handle)
{
  m_SpriteHandle = handle;
}



/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- set_enemy() */
/**
 * Xe[WJn̓GQ̈ʒu
 *
 * @return 
 *
 */
void  ConvoyManage::set_enemy()
{
  int  i, j;
  int height;

  /* --- X^[gʒu̍ (`340) */
  height = 240 + (m_Level * 10);
  if (height > 340) {
    height = 340;
  }
  /* --- Q̃IuWFNg */
  for(i=0; i<CV_ROW; i++) {
    for(j=0; j<CV_COLUMN; j++) {
      /* - IuWFNg̏ */
      m_Convoy[j+(i*CV_COLUMN)].m_SizeW = 16;
      m_Convoy[j+(i*CV_COLUMN)].m_SizeH = 24;
      m_Convoy[j+(i*CV_COLUMN)].m_Priority = BS_DEPTH_ENEMY;
      m_Convoy[j+(i*CV_COLUMN)].m_Blend = 1.0;
      m_Convoy[j+(i*CV_COLUMN)].m_Zoom = 1.0;
      m_Convoy[j+(i*CV_COLUMN)].m_TexW = 16;
      m_Convoy[j+(i*CV_COLUMN)].m_TexH = 24;
      m_Convoy[j+(i*CV_COLUMN)].m_RollZ = 0.0;
      m_Convoy[j+(i*CV_COLUMN)].m_PosCenter = true;
      m_Convoy[j+(i*CV_COLUMN)].m_Working = true;
      m_Convoy[j+(i*CV_COLUMN)].m_Visible = true;
      m_Convoy[j+(i*CV_COLUMN)].SetCharactor(SIENSIDE);
      m_Convoy[j+(i*CV_COLUMN)].SetWalkPattern(0);
      /* - 蔻 */
      m_Convoy[j+(i*CV_COLUMN)].SetHitSize(8.0);
      m_Convoy[j+(i*CV_COLUMN)].SetGrazeSize(8.0);
      m_Convoy[j+(i*CV_COLUMN)].m_HitEnable = true;
      /* - ʒu */
      m_Convoy[j+(i*CV_COLUMN)].m_PosX = 40 + (j * 40);
      m_Convoy[j+(i*CV_COLUMN)].m_PosY = height;
      /* - XvCg */
      m_Convoy[j+(i*CV_COLUMN)].SetLunaSprite(m_SpriteHandle);
      /* - _ */
      m_Convoy[j+(i*CV_COLUMN)].SetScore((i+1)*1000);
    }
    height -= 50;
  }
}


/* ----------------------------------------- */
/* --- attack_enemy() */
/**
 * eŨNGXg
 *
 * @return 
 *
 */
void  ConvoyManage::attack_enemy()
{
  int  enemy_rest_w[CV_COLUMN];
  int  enemy_attack_list[CV_COLUMN];
  int  line_num;
  int  i, j, n, max, level;

  /* --- UłGLN^[T */
  line_num = 0;
  for(i=0; i<CV_COLUMN; i++) {
    enemy_rest_w[i] = 0;
    enemy_attack_list[i] = 0;
  }
  for(j=0; j<CV_ROW; j++) {
    for(i=0; i<CV_COLUMN; i++) {
      n = i + (j * CV_COLUMN);
      if (m_Convoy[n].m_Working) {
	if (enemy_rest_w[i] < (4-j)) {
	  enemy_rest_w[i] = (4-j);
	}
      }
    }
  }
  for(i=0; i<CV_COLUMN; i++) {
    if (enemy_rest_w[i] > 0) {
      enemy_attack_list[line_num] = i;
      line_num += 1;
    }
  }

  /* --- Ux */
  n = GetRestEnemy();
  if (n > 35) {
    max = 1;
  } else if (n > 25) {
    max = 2;
  } else if (n > 15) {
    max = 3;
  } else {
    max = 4;
  }
  level = LunaMath::Rand(0, (max - 1));
  
  /* --- ULI */
  n = LunaMath::Rand(0, (line_num - 1));
  i = enemy_attack_list[n];
  j = enemy_rest_w[i];
  if (j > 0) {
    n = i + ((4 - j) * CV_COLUMN);
    /* - UNGXg */
    m_BulletMaker->SetEnemyObject(&(m_Convoy[n]));
    m_BulletMaker->RequestBullet(level);
  }
}

