/* ---------------------------------------------------------- */
/*  bulletmanage.cpp                                          */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		eʂ̊ǗNX
    @author		K.Kunikane (끗ӂ)
    @since		Feb.17.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "bulletmanage.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
BulletManage::BulletManage()
{
  /* ---  */
  m_BulletNum = 0;
  m_ListHead = NULL;
  m_ListTail = NULL;
}


/**
 * fXgN^(n)
 */
BulletManage::~BulletManage()
{
  BulletMaker*  obj;
  BulletMaker*  next;

  /* --- eXgɐςłIuWFNgSĉ */
  obj = (BulletMaker*)m_ListHead;
  try {
    while(obj != NULL) {
      next = (BulletMaker*)obj->m_ListNext;
      delete obj;
      obj = next;
    }
  }
  catch(...) {
  }
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- Init() */
/**
 * (Q[I[o[Ƃ)
 *
 * @return 
 *
 */
void  BulletManage::Init()
{
  BulletMaker  *obj, *next;

  /* --- eXgɐςłIuWFNgSĉ */
  obj = (BulletMaker*)m_ListHead;
  try {
    while(obj != NULL) {
      next = (BulletMaker*)obj->m_ListNext;
      delete obj;
      obj = next;
    }
  }
  catch(...) {
  }
  /* --- oNA */
  m_BulletNum = 0;
  m_ListHead = NULL;
  m_ListTail = NULL;
}


/* ----------------------------------------- */
/* --- Tick() */
/**
 * SẴIuWFNg 1t[ړ
 *
 * @return true ŒʏIAfalse ̎̓IuWFNg
 *
 */
bool  BulletManage::Tick()
{
  BulletMaker  *obj, *next;
  bool result;

  /* --- IuWFNgۂł */
  if (m_BulletNum == 0) {
    return(false);
  }

  /* --- eXgɐςłIuWFNgS */
  obj = (BulletMaker*)m_ListHead;
  try {
    while(obj != NULL) {
      next = (BulletMaker*)obj->m_ListNext;
      result = obj->Tick();
      if (result == false) {
	/* sIuWFNgj */
	delete_bullet(obj);
      }
      /* -  */
      obj = next;
    }
  }
  catch(...) {
  }

  return(true);
}


/* ----------------------------------------- */
/* --- Display() */
/**
 * SẴIuWFNgv~eBuƂ
 * XvCgobt@ɐς
 *
 * @return ۂɍƂIuWFNg
 *
 */
int  BulletManage::Display()
{
  BulletMaker  *obj, *next;
  int  i, n;

  /* --- \̓obt@̍ő吔܂łł */
  obj = (BulletMaker*)m_ListHead;
  n = 0;
  for(i=0; i<BS_SPBUF_BULLET; i++) {
    if (obj == NULL) {
      /* ܂ */
      break;
    }
    next = (BulletMaker*)obj->m_ListNext;
    obj->Display();
    /* -  */
    obj = next;
    n += 1;
  }

  return(n);
}


/* ----------------------------------------- */
/* --- AddBullet() */
/**
 * IuWFNgXgɒǉ
 *
 * @return ۂɍƂIuWFNg
 *
 */
bool  BulletManage::AddBullet(void* obj)
{
  BulletMaker *mobj, *tail;
  bool  result;

  mobj = (BulletMaker*)obj;
  result = true;
  /* --- obt@̐葽Ȃ肻ς܂Ȃ */
  if (m_BulletNum < BS_SPBUF_BULLET) {
    if (m_ListHead == NULL) {
      /* - ŏ̈ꔭڂ͐擪ɂL^ */
      m_ListHead = (void*)obj;
    }
    /* - XgŌɒǉ */
    mobj->m_ListPrev = m_ListTail;
    mobj->m_ListNext = NULL;
    if (m_ListTail) {
      tail = (BulletMaker*)m_ListTail;
      tail->m_ListNext = (void*)mobj;
    }
    m_ListTail = (void*)mobj;
    m_BulletNum += 1;
  }
  else {
    result = false;
  }

  return(result);
}


/* ----------------------------------------- */
/* --- CheckHit() */
/**
 * @ƒeƂ̃qbg()
 *
 * @return @ɒeĂƂ true, ȊO false
 *
 */
bool  BulletManage::CheckHit(ShootingObject* ship)
{
  BulletMaker  *obj, *next;
  bool  result;

  result = false;
  /* --- 蔻̃NA */
  m_Graze = 0;
  /* --- eXgɐςłIuWFNgS */
  obj = (BulletMaker*)m_ListHead;
  try {
    while(obj != NULL) {
      next = (BulletMaker*)obj->m_ListNext;
      /* - 蔻肪eΏ */
      if (obj->m_HitEnable) {
	/* 蔻 */
	if (obj->CheckCollision(ship)) {
	  result = true;
	}
	/* 蔻 */
	else if (obj->CheckGraze(ship)) {
	  m_Graze += 1;
	  /* e͓xƔfȂ悤 */
	  obj->m_GrazeEnable = false;
	}
      }
      /* -  */
      obj = next;
    }
  }
  catch(...) {
  }

  return(result);
}


/* ----------------------------------------- */
/* --- GetGraze() */
/**
 * 蔻̌ʂn
 *
 * @return 蓾_
 *
 */
int  BulletManage::GetGraze()
{
  return(m_Graze);
}


/* ----------------------------------------- */
/* --- DisableAllBullet() */
/**
 * ݉ʏɎcĂẽ{[iXNA
 *
 * @return ce{[iX
 *
 */
int  BulletManage::DisableAllBullet()
{
  BulletMaker  *obj, *next;
  int  score;

  score = 0;
  /* --- eXgɐςłIuWFNgS */
  obj = (BulletMaker*)m_ListHead;
  try {
    while(obj != NULL) {
      next = (BulletMaker*)obj->m_ListNext;
      /* - 蔻肪eΏ */
      if (obj->m_HitEnable) {
	obj->m_HitEnable = false;
	obj->m_LifeTime = 15;
	obj->m_Blend = 0.3;
	score += 100;
      }
      /* -  */
      obj = next;
    }
  }
  catch(...) {
  }

  return(score);
}


/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

void  BulletManage::delete_bullet(void *obj)
{
  BulletMaker *mobj, *prevobj, *nextobj;

  mobj = (BulletMaker*)obj;

  /* --- Xg؂藣 */
  if (m_ListHead == mobj) {
    m_ListHead = mobj->m_ListNext;
  }
  if (m_ListTail == mobj) {
    m_ListTail = mobj->m_ListPrev;
  }
  prevobj = (BulletMaker*)mobj->m_ListPrev;
  nextobj = (BulletMaker*)mobj->m_ListNext;
  if (prevobj) {
    prevobj->m_ListNext = mobj->m_ListNext;
  }
  if (nextobj) {
    nextobj->m_ListPrev = mobj->m_ListPrev;
  }
  /* --- IuWFNg̃[X */
  delete mobj;
  m_BulletNum -= 1;
}


void*  BulletManage::get_next_bullet(void* obj)
{
  BulletMaker *mobj;

  mobj = (BulletMaker*)obj;
  /* --- KvȂ̂̃\bhH */
  return((void*)mobj->m_ListNext);
}


