/* ---------------------------------------------------------- */
/*  bulletbase.cpp                                            */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		eƂ̔łIuWFNgNX
    @author		K.Kunikane (끗ӂ)
    @since		Feb.15.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "bulletbase.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
BulletBase::BulletBase()
{
  /* ---  */
  m_EnemyObject = NULL;
  m_Direction = 0.0;
  m_DirectionAdd = 0.0;
  m_Speed = 1.0;
  m_SpeedR = 0.0;
  m_Accelerator = 0.0;
  m_Accelerator = 0.0;
  m_Limit = 0.0;
  m_LimitR = 0.0;
  m_AddRoll = 0.0;
  m_Timer = 0;
  m_LifeTime = 0;
  m_ListPrev = NULL;
  m_ListNext = NULL;
}


/**
 * fXgN^(n)
 */
BulletBase::~BulletBase()
{
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- SetHitSize() */
/**
 * IuWFNg1t[ړ
 *
 * @return true ȂIuWFNgAfalse ŏI
 *
 */
bool BulletBase::Tick()
{
  bool  alive;
  float  dx, dy;

  alive = true;

  /* ---  */
  /* - isx */
  if (m_Speed < m_Limit) {
    m_Speed += m_Accelerator;
    if (m_Speed < 0) {
      m_Speed = 0;
    }
  }
  /* - isω */
#if 0
  /* ȂɂPSPŉZG[N̂ */
  m_SpeedR += m_AcceleratorR;
  if (m_DirectionAdd >= 0) {
    if (m_DirectionAdd < m_LimitR) {
      m_DirectionAdd += m_SpeedR;
    }
  }
  else {
    if (m_DirectionAdd > m_LimitR) {
      m_DirectionAdd += m_SpeedR;
    }
  }
#endif

  /* - LN^[] */
  m_RollZ = (float)((int)(m_RollZ + m_AddRoll) % 65536);

  /* --- is1ړ */
  dx = LunaMath::Cos(((long)(m_Direction + m_DirectionAdd) % 65536));
  dy = LunaMath::Sin(((long)(m_Direction + m_DirectionAdd) % 65536));
  dx *= m_Speed;
  dy *= m_Speed;
  m_PosX += dx;
  m_PosY += dy;

  /* --- \̈͂ݏo`FbN */
  if ((m_PosX + (m_SizeW / 2.0)) <= 0) {
    alive = false;
  }
  if ((m_PosX - (m_SizeW / 2.0)) >= GAMEFIELD_W) {
    alive = false;
  }
  if ((m_PosY + (m_SizeH / 2.0)) <= 0) {
    alive = false;
  }
  if ((m_PosY - (m_SizeH / 2.0)) >= GAMEFIELD_H) {
    alive = false;
  }

  /* --- JE^[ */
  if (m_LifeTime > 0) {
    m_LifeTime -= 1;
  }
  else {
    m_LifeTime = 0;
    alive = false;
  }

  /* --- ܂ */
  return(alive);
}

/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

