/**
 *  --- SDL puzzle project 'tailtale'.
 *
 */

#include <stdlib.h>

#include "SDL.h"
#include "SDL_main.h"
#include "SDL_Audio.h"
#include "SDL_mixer.h"

#include "bootmain.h"
#include "debug.h"
#include "input.h"
#include "sound.h"
#include "grp_screen.h"

#include "gamemain.h"

TGameScreen  *scr;
TGameMain  *gamemain;

/* --------------------------------------------- */
/* --- C[`                        --- */
/* --------------------------------------------- */
extern "C" int  main(int argc, char *argv[])
{
  int  i;
  /* --- C[`[vtO */
  int  endflag;
  /* --- ^CJEg */
  int  SystemTime;
  int  BeforeTiming;
  int  NowTiming;
  int  WorkTime;
  int  DispTime;
  int  FrameCounter;
  int  FrameSkip;

  WorkTime = 0;
  FrameSkip = 0;

  /* ----- SDL  */
  i = SDL_Init(SDL_INIT_VIDEO |
	       SDL_INIT_AUDIO | 
	       SDL_INIT_TIMER |
	       SDL_INIT_JOYSTICK );
  if (i != 0) {
    /* --- SDLłȂ */
#ifdef DEBUG
    printf("SDL initialize error.\n");
#endif
    exit(-1);
  }

  /* --- ItO */
  endflag = 0;

  /* ----- n[hEFA */
  InputInit();
  SoundInit();
  scr = TGameScreen_Create(SCREEN_WIDTH, SCREEN_HEIGHT,
			   SCREEN_DEPTH);

  TGameScreen_SetWMName(scr, WindowName);
  SystemTime = SDL_GetTicks();
  BeforeTiming = SystemTime;
  DispTime = 0;
  FrameCounter = 0;
  srand(1);

  /* ----- Q[{̏ */
  gamemain = TGameMain_Create(scr);

  /* ---------------------------------------- */
  /* ----- C[`                     */
  /* ---------------------------------------- */
  while(endflag == 0) {
    /* --- Q[{̃[v */
    for(i=0; i<=FrameSkip; i++) {
      FrameCounter = FrameCounter + 1;
      InputPoll();
      /* ------------------------------- */
      /* ----- Q[C */
      if ((TGameMain_Poll(gamemain, FrameCounter) == FALSE) ||
	  (InputExit() != 0)) {
	BeforeTiming = SDL_GetTicks();
	break;
      }
    }

    /* ----- fobOpĎ */
    DEBUGPRINT("%d", FrameCounter);
    DEBUGPRINT("Work Time : W%02d/D%02d/%d", WorkTime, DispTime, (1000/FRAME_RATE));
    DEBUGPRINT("Frame Skip : %d", FrameSkip);
    DEBUGPRINT("Key Input : %x", InputJoyKey(0));

    WorkTime = SDL_GetTicks() - BeforeTiming;

    /* --- t[IAXN[` */
    TGameScreen_RefreshScreen(scr);
    /* --- t[^C}[ */
    DispTime = SDL_GetTicks() - BeforeTiming;
#ifdef NOTPSP
    NowTiming = (1000 / FRAME_RATE) - WorkTime;
    if ((NowTiming > 0) && (NowTiming <= (1000 / FRAME_RATE))) {
      SDL_Delay(NowTiming);
    }
    endflag = InputExit();
    FrameSkip = DispTime / (1000 / FRAME_RATE);
#else
    FrameSkip = 0;
#endif
    BeforeTiming = SDL_GetTicks();


    /* ---------------------------------------- */
    /* ----- C[vRR܂               */
  }

  /* --- Q[C[vI */
  TGameMain_Destroy(gamemain);
  /* --- XN[ */
  TGameScreen_Destroy(scr);
  /* --- IASDL ㏈ */
  SoundFree();
  InputFree();
  SDL_Quit();

  return(0);
}

