/* ---------------------------------------------------------- */
/*  bonusshipmanage.cpp                                          */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		{[iXD̊ǗNX
    @author		K.Kunikane (끗ӂ)
    @since		Feb.18.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "lunavader.h"
#include "basicsystem.h"
#include "bonusshipmanage.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
BonusShipManage::BonusShipManage()
{
  /* ---  */
  m_Appear = false;
  m_Timer = 0;
  m_Charactor = 0;
  m_Score = 0;
}


/**
 * fXgN^(n)
 */
BonusShipManage::~BonusShipManage()
{
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- Tick() */
/**
 * t[Ƃ̍
 *
 * @return true ȂړAfalse Ȃ~
 *
 */
bool BonusShipManage::Tick()
{
  bool  result;

  /* --- X[p[NX Tick Ăяo */
  result = BulletBase::Tick();
  m_Appear = result;
  if (result == false) {
    m_Working = false;
    m_Visible = false;
    m_HitEnable = false;
  }
  else {
    /* --- 2R}Aj[V */
    m_Timer += 1;
    m_TexU = 64 + (24 * ((m_Timer / 4) % 2));
  }

  return(result);
}

/* ----------------------------------------- */
/* --- Start() */
/**
 * oNGXg
 *
 * @return true Ȃ甭ˏAfalse Ȃ珈
 *
 */
bool BonusShipManage::Start()
{
  bool  alive;
  int  dir;

  alive = false;

  if (m_Appear == false) {
    /* --- {[iXDIuWFNg̐ */
    /* - is */
    dir = LunaMath::Rand(0, 1);
    /* - IuWFNg̏ */
    m_SizeW = 24;
    m_SizeH = 24;
    m_Priority = BS_DEPTH_BONUSSHIP;
    m_Blend = 1.0;
    m_Zoom = 1.0;
    m_TexU = 64;
    m_TexV = 24 * m_Charactor;
    m_TexW = 24;
    m_TexH = 24;
    m_RollZ = 0.0;
    m_PosCenter = true;
    m_Working = true;
    m_Visible = true;
    /* - 蔻 */
    SetHitSize(16.0);
    SetGrazeSize(16.0);
    m_HitEnable = true;
    /* - ʒu */
    if (dir) {
      m_PosX = 1;
      m_Direction = 0.0;
    }
    else {
      m_PosX = GAMEFIELD_W - 2;
      m_Direction = (65535.0 / 2);
    }
    m_PosY = 40;
    /* - ړx */
    m_DirectionAdd = 0.0;
    m_Speed = 2.0;
    m_SpeedR = 0.0;
    m_Accelerator = 0.0;
    m_AcceleratorR = 0.0;
    m_Limit = 5.0;
    m_LimitR = 0.0;
    m_AddRoll = 0.0;
    m_LifeTime = 3600;
    /* - s */
    m_Timer = 0;
    m_Appear = true;
    alive = true;
  }

  /* --- ܂ */
  return(alive);
}


/* ----------------------------------------- */
/* --- GetState() */
/**
 * ݏoǂ̊mF
 *
 * @return true ȂoAfalse Ȃҋ@
 *
 */
bool BonusShipManage::GetState()
{
  return(m_Appear);
}

/* ----------------------------------------- */
/* --- SetCharactor() */
/**
 * \LN^[w
 *
 * @param chr [in] LN^[
 * @return Ȃ
 *
 */
void BonusShipManage::SetCharactor(int chr)
{
  m_Charactor = chr;
  m_Appear = false;
  m_Working = false;
  m_Visible = false;
  m_HitEnable = false;
}

/* ----------------------------------------- */
/* --- SetScore() */
/**
 * j󂵂Ƃ̃{[iX_Zbg
 *
 * @param score [in] XRA
 * @return Ȃ
 *
 */
void  BonusShipManage::SetScore(int score)
{
  m_Score = score;
}


/* ----------------------------------------- */
/* --- GetScore() */
/**
 * j󂵂Ƃ̃{[iX_
 *
 * @return XRA
 *
 */
int  BonusShipManage::GetScore()
{
  return(m_Score);
}


/* ----------------------------------------- */
/* --- CheckHit() */
/**
 * @e̔
 *
 * @return XRA
 *
 */
bool BonusShipManage::CheckHit(ShootingObject *shot)
{
  bool result;

  result = CheckCollision(shot);
  if (result == true) {
    /* -- eړ~ */
    m_Working = false;
    m_Visible = false;
    m_HitEnable = false;
    m_Appear = false;
    /* -- êق~ */
    shot->m_Working = false;
    shot->m_Visible = false;
    shot->m_HitEnable = false;
  }

  return(result);
}


/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

