/* ---------------------------------------------------------- */
/*  BasicSystem.h                                             */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		Luna system ̉Bƒۉ
    @author		K.Kunikane (끗ӂ)
    @since		Feb.12.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.

 Convert to PSP - Oct.15.2006
 ------------------------------------------------------*/

#ifndef BASICSYSTEM_H
#define BASICSYSTEM_H

/*-------------------------------*/
/* include                       */
/*-------------------------------*/

#include "lunavader.h"
#include "input.h"
#include "sound.h"
#include "debug.h"
#include "grp_screen.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

//! vC[͂̃rbg
#define  BS_INPUT_UP       IN_Up
#define  BS_INPUT_DOWN     IN_Down
#define  BS_INPUT_LEFT     IN_Left
#define  BS_INPUT_RIGHT    IN_Right
#define  BS_INPUT_BUTTON1  IN_Button1
#define  BS_INPUT_BUTTON2  IN_Button2
#define  BS_INPUT_BUTTON3  IN_Button3
#define  BS_INPUT_BUTTON4  IN_Button4

//! @\p̃XvCgobt@̃TCY
#define  BS_SPBUF_MYSHIP  1
//! e\p̃XvCgobt@̃TCY
#define  BS_SPBUF_MYSHOT  1
//! GQ̕\p̃XvCgobt@̃TCY
#define  BS_SPBUF_ENEMY   50
//! {[iXD\p̃XvCgobt@̃TCY
#define  BS_SPBUF_BONUSSHIP  1
//! GeGtFNg̃XvCgobt@̃TCY
#define  BS_SPBUF_BULLET  800
//! wi\p̃XvCgobt@̃TCY
#define  BS_SPBUF_BACKGROUND  10
//! XRApl\p̃XvCgobt@̃TCY
#define  BS_SPBUF_PANEL  50
//! ^Cgʕ\p̃XvCgobt@̃TCY
#define  BS_SPBUF_TITLE  10

//! @\p̃XvCg[x
#define  BS_DEPTH_MYSHIP  10
//! e\p̃XvCg[x
#define  BS_DEPTH_MYSHOT  8
//! GQ̕\p̃XvCg[x
#define  BS_DEPTH_ENEMY   15
//! {[iXD\p̃XvCg[x
#define  BS_DEPTH_BONUSSHIP  15
//! GeGtFNg̃XvCg[x
#define  BS_DEPTH_BULLET  5
//! wi\p̃XvCg[x
#define  BS_DEPTH_BACKGROUND  100
//! XRApl\p̃XvCg[x
#define  BS_DEPTH_PANEL  5
//! XRApl̕\p̃XvCg[x
#define  BS_DEPTH_PANELITEM  6
//! ^Cgʕ\p̃XvCg[x
#define  BS_DEPTH_TITLE  50


/*-------------------------------*/
/* struct                        */
/*-------------------------------*/

/*-------------------------------*/
/* class                         */
/*-------------------------------*/

/**
 * @brief system Rg[NX
 *        X Luna Cuւ̃ANZXBNX
 *        \O SDLVXeɈڂւ
 *
 * @todo -
 * @bug -
 */
class BasicSystem
{
  /* ----------------------------------- */
  /* --- RXgN^EfXgN^ */
 public:
  BasicSystem();
  virtual  ~BasicSystem();

  /* ----------------------------------- */
  /* --- pubNo */
 public:
  //! Q[XRA
  long  m_Score;
  //! Q[nCXRA
  long  m_HighScore;

  //! XN[nh
  TGameScreen  *screen;

  /* ----------------------------------- */
  /* --- vCx[go */
 private:

  /* ----------------------------------- */
  /* --- pubN\bh */
 public:
  void Init();
  void Release();
  void Tick();
  void DisplayUpdate();
  TGameSprite *GetSpriteNext();
  unsigned long GetKeyInput();
  unsigned long GetKeyInputTriger();
  void PlaySoundEffect(int num);
  void PlayMusic(int num);
  void StopMusic();
  void AddDebugMessage(unsigned char *line);


  /* ----------------------------------- */
  /* --- vCx[g\bh */
 private:

};


#endif

