/* ---------------------------------------------------------- */
/*  basicsystem.cpp                                           */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		system ̉Bƒۉ
    @author		K.Kunikane (끗ӂ)
    @since		Feb.12.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.

 Convert to PSP - Oct.15.2006
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "basicsystem.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/* --- eNX`t@C */
char* texture_name[] = {
  "texture1.png",
  "clip1.png",
};

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
BasicSystem::BasicSystem()
{
}


/**
 * fXgN^(n)
 */
BasicSystem::~BasicSystem()
{
  StopMusic();
  /* --- Luna nh̉(cĂ) */
  Release();
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- Init() */
/**
 * eNX`ǂݍݓ̍ƂsB
 * Ƃ construct ɂ͍sꂸ Init ɂčsB
 *
 * @return 
 *
 */
void BasicSystem::Init()
{
  /* --- TEh̏ */
  SoundMusicStop();
  SoundSEStop();

  /* --- eNX`̏ */
  if (screen != 0) {
#ifdef __PSP__
    TGameScreen_LoadTexture(screen, 0, texture_name[0]);
    TGameScreen_LoadTexture(screen, 1, texture_name[1]);
#else
    TGameScreen_LoadTexturePure(screen, 0, texture_name[0]);
    TGameScreen_LoadTexturePure(screen, 1, texture_name[1]);
#endif
  }
}

/* ----------------------------------------- */
/* --- Release() */
/**
 * Luna Ǘnh
 *
 * @return 
 *
 */
void BasicSystem::Release()
{
  /* - Ȃɂ܂ */
}

/* ----------------------------------------- */
/* --- Tick() */
/**
 * t[Ƃ̍ƂsB
 * ̓Iɂ Input ǂݎƃXvCgobt@̈ꊇ`B
 *
 * @return 
 *
 */
void BasicSystem::Tick()
{
  /* --- t[ɌXvCg̃Zbg */
  TGameScreen_ClearSprite(screen);
}

/* ----------------------------------------- */
/* --- DisplayUpdate() */
/**
 * XvCgobt@̍XV
 * Sync EFCg̑OɓăR[
 *
 * @return 
 *
 */
void BasicSystem::DisplayUpdate()
{
  /* --- t[ɌXvCg̃Abvf[g */
}


/* ----------------------------------------- */
/* --- GetSpriteNext() */
/**
 * XvCgIuWFNg擾
 *
 * @return 
 *
 */
TGameSprite *BasicSystem::GetSpriteNext()
{
  return(TGameScreen_GetSpriteSerial(screen));
}


/* ----------------------------------------- */
/* --- GetKeyInput() */
/**
 * ͂nB
 *
 * @return 
 *
 */
unsigned long BasicSystem::GetKeyInput()
{
  return(InputJoyKey(0));
}

/* ----------------------------------------- */
/* --- GetKeyInputTriger() */
/**
 * ͂̃gK[󋵂nB
 *
 * @return 
 *
 */
unsigned long BasicSystem::GetKeyInputTriger()
{
  return(InputJoyKeyTriger(0));
}


/* ----------------------------------------- */
/* --- PlaySoundEffect() */
/**
 * w肵ԍ̌ʉ炵܂
 *
 * @param num [in] 炷ʉ̔ԍ
 * @return 
 *
 */
void BasicSystem::PlaySoundEffect(int num)
{
  SoundSE(num);
}

/* ----------------------------------------- */
/* --- PlayMusic() */
/**
 * w肵ԍ̃TEhXg[tJn
 *
 * @param num [in] 炷ʉ̔ԍ
 * @return 
 *
 */
void BasicSystem::PlayMusic(int num)
{
  SoundMusic(num);
}

/* ----------------------------------------- */
/* --- StopMusic() */
/**
 * ݃Xg[t炻~
 *
 * @return 
 *
 */
void BasicSystem::StopMusic()
{
  SoundMusicStop();
}

/* ----------------------------------------- */
/* --- AddDebugMessage() */
/**
 * fobOp\̒ǉ
 *
 * @param line [in] fobO\ string
 * @return 
 *
 */
void BasicSystem::AddDebugMessage(unsigned char *line)
{
#ifdef DEBUG
  TDebugPrint((char*)line);
#endif
}


/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

