/* ---------------------------------------------------------- */
/*  backgroundmanage.cpp                                      */
/* ---------------------------------------------------------- */

/*------------------------------------------------------------- */
/** @file
    @brief		Q[̔wiǗ
    @author		K.Kunikane (끗ӂ)
    @since		Feb.18.2005
    $Revision: 1.1.1.1 $
*/
/*-----------------------------------------------------
 Copyright (C) 2005 rero2@fumi <rero2@yuumu.org>
 All Rights Reserved.
 ------------------------------------------------------*/

/*-------------------------------*/
/* include                       */
/*-------------------------------*/
#include "basicsystem.h"
#include "backgroundmanage.h"

/*-------------------------------*/
/* define                        */
/*-------------------------------*/

/*-------------------------------*/
/* global value                  */
/*-------------------------------*/

/*-------------------------------*/
/* local routine                 */
/*-------------------------------*/

/*-------------------------------*/
/* implementatiion               */
/*-------------------------------*/

/*------------------------------------------------------*/
/* constructor/destructor                               */
/*------------------------------------------------------*/

/**
 * RXgN^
 */
BackGroundManage::BackGroundManage()
{
  int  i;

  /* ---  */
  m_BackBlend = 0;
  /* --- XvCg */
  for(i=0; i<BACKGROUND_LAYER; i++) {
    bg[i] = new SpriteItem;
  }
}


/**
 * fXgN^(n)
 */
BackGroundManage::~BackGroundManage()
{
  int i;

  for(i=0; i<BACKGROUND_LAYER; i++) {
    delete  bg[i];
  }
}



/*------------------------------------------------------*/
/* interface                                            */
/*------------------------------------------------------*/

/* ----------------------------------------- */
/* --- Init() */
/**
 * wiXvCg̏
 *
 * @return  true
 *
 */
void BackGroundManage::Init()
{
  /* - IuWFNg̏ 1 */
  bg[0]->m_PosX = GAMEFIELD_W / 2;
  bg[0]->m_PosY = GAMEFIELD_H / 2;
  bg[0]->m_SizeW = 128;
  bg[0]->m_SizeH = 128;
  bg[0]->m_Priority = BS_DEPTH_BACKGROUND;
  bg[0]->m_Blend = 1.0;
  bg[0]->m_Zoom = 2.0;
  bg[0]->m_TexU = 0;
  bg[0]->m_TexV = 64;
  bg[0]->m_TexW = 128;
  bg[0]->m_TexH = 128;
  bg[0]->m_RollZ = 0.0;
  bg[0]->m_PosCenter = true;
  bg[0]->m_Working = true;
  bg[0]->m_Visible = true;
  /* - IuWFNg̏ 2 */
  bg[1]->m_PosX = GAMEFIELD_W / 2;
  bg[1]->m_PosY = GAMEFIELD_H / 2;
  bg[1]->m_SizeW = 128;
  bg[1]->m_SizeH = 128;
  bg[1]->m_Priority = BS_DEPTH_BACKGROUND + 1;
  bg[1]->m_Blend = 0.0;
  bg[1]->m_Zoom = 3.0;
  bg[1]->m_TexU = 128;
  bg[1]->m_TexV = 64;
  bg[1]->m_TexW = 128;
  bg[1]->m_TexH = 128;
  bg[1]->m_RollZ = 0.0;
  bg[1]->m_PosCenter = true;
  bg[1]->m_Working = true;
  bg[1]->m_Visible = true;

}


/* ----------------------------------------- */
/* --- Tick() */
/**
 * wi̓Ǘ
 *
 * @return  true
 *
 */
bool BackGroundManage::Tick()
{
  int  roll;

  /* --- wi] */
  roll = (int)bg[1]->m_RollZ;
  roll = (roll + 100) % 65536;
  bg[1]->m_RollZ = (float)roll;  
  /* --- xύX */
  if (bg[1]->m_Blend < m_BackBlend) {
    bg[1]->m_Blend += 0.01;
  }
  else {
    bg[1]->m_Blend -= 0.01;
  }

  return(true);
}


/* ----------------------------------------- */
/* --- Display() */
/**
 * XvCg̕\
 * p[^ɏ]ăXvCgv~eBu LunaSprite 
 * o^
 *
 * @return Ȃ\ true s false
 *
 */
bool BackGroundManage::Display()
{
  int i;

  for(i=0; i<BACKGROUND_LAYER; i++) {
    bg[i]->Display();
  }

  return(true);
}


/* ----------------------------------------- */
/* --- SetLunaSprite() */
/**
 * ʂō쐬 LunaSprite nhnĂ炤
 * ̃NX͓nꂽnh̃v~eBuƂȂ
 *
 * @param sp_handle [in] LunaSpritenh
 * @return 
 *
 */
void BackGroundManage::SetLunaSprite(LSPRITE sp_handle)
{
  int i;

  m_LunaSprite = sp_handle;
  for(i=0; i<BACKGROUND_LAYER; i++) {
    bg[i]->SetLunaSprite(sp_handle);
  }
  
}


/* ----------------------------------------- */
/* --- SetBlend() */
/**
 * wiʖʂ̔ڕWlݒ
 *
 * @param blend [in] ڕWl
 * @return 
 *
 */
void BackGroundManage::SetBlend(float  blend)
{
  m_BackBlend = blend;
}





/*------------------------------------------------------*/
/* local work                                           */
/*------------------------------------------------------*/

